/*
 * Decompiled with CFR 0.152.
 */
package cn.torna.swaggerplugin.starter;

import cn.torna.swaggerplugin.SwaggerPluginConfiguration;
import cn.torna.swaggerplugin.bean.TornaConfig;
import cn.torna.swaggerplugin.starter.TornaProperties;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={TornaProperties.class})
public class TornaAutoConfiguration {
    private final TornaProperties tornaProperties;

    public TornaAutoConfiguration(TornaProperties tornaProperties) {
        this.tornaProperties = tornaProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="torna.swagger-plugin", name={"enable"}, havingValue="true")
    public SwaggerPluginConfiguration swaggerPluginConfiguration() {
        TornaConfig tornaConfig = new TornaConfig();
        BeanUtils.copyProperties((Object)this.tornaProperties, (Object)tornaConfig);
        return new SwaggerPluginConfiguration(tornaConfig);
    }
}

