/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.tool.util;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.extra.validation.ValidationUtil;
import org.jetbrains.annotations.Contract;

public class Assert {
    @Contract(value="null, _, _ -> fail")
    public static void notNull(@Nullable Object object, @Nullable CharSequence template, Object ... params) {
        if (object == null) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    @Contract(value="!null, _, _ -> fail")
    public static void isNull(@Nullable Object object, @Nullable CharSequence template, Object ... params) {
        if (object != null) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    @Contract(value="null, _, _ -> fail")
    public static void notBlank(@Nullable CharSequence text, @Nullable CharSequence template, Object ... params) {
        if (StringUtils.isBlank((CharSequence)text)) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    @Contract(value="null, _, _ -> fail")
    public static void notEmpty(@Nullable Object[] arr, @Nullable CharSequence template, Object ... params) {
        if (arr == null || arr.length == 0) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    @Contract(value="null, _, _ -> fail")
    public static void notEmpty(@Nullable Iterable<?> collection, @Nullable CharSequence template, Object ... params) {
        if (collection == null || !collection.iterator().hasNext()) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    @Contract(value="null, _, _ -> fail")
    public static void notEmpty(@Nullable Map<?, ?> map, @Nullable CharSequence template, Object ... params) {
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    public static void equals(@Nullable Object a, @Nullable Object b, @Nullable CharSequence template, Object ... params) {
        if (!Objects.equals(a, b)) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    public static void notEquals(@Nullable Object a, @Nullable Object b, @Nullable CharSequence template, Object ... params) {
        if (Objects.equals(a, b)) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    @Contract(value="false, _, _ -> fail")
    public static void isTrue(boolean b, @Nullable CharSequence template, Object ... params) {
        if (!b) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void isFalse(boolean b, @Nullable CharSequence template, Object ... params) {
        if (b) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    @Contract(value="null, _ -> fail")
    public static void validate(@Nullable Object object, Class<?> ... groups) {
        ValidationUtil.validateAndThrowFirst((Object)object, (Class[])groups);
    }

    @Contract(value="null, _, _ -> fail")
    public static void validate(@Nullable Object object, @Nullable CharSequence template, Object ... params) {
        if (object == null) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
        try {
            ValidationUtil.validateAndThrowFirst((Object)object, (Class[])new Class[0]);
        }
        catch (Exception e) {
            if (StringUtils.isBlank((CharSequence)template)) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            ArrayList<Object> newParams = new ArrayList<Object>();
            if (ArrayUtil.isNotEmpty((Object[])params)) {
                newParams.addAll(Arrays.asList(params));
            }
            newParams.add(e.getMessage());
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])newParams.toArray()), e);
        }
    }
}

