/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.tool.util;

import cn.toint.tool.exception.RetryException;
import cn.toint.tool.util.Assert;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.thread.ThreadUtil;

public class RetryUtil {
    @SafeVarargs
    public static <R> R execute(@Nonnull Callable<R> callable, int retrySize, @Nonnull Duration intervalTime, Class<? extends Throwable> ... exceptionClass) {
        Assert.notNull(callable, "callable must not be null", new Object[0]);
        Assert.notNull(intervalTime, "intervalTime must not be null", new Object[0]);
        HashSet<Class<Throwable>> classes = new HashSet<Class<Throwable>>();
        if (ArrayUtil.isNotEmpty((Object[])exceptionClass)) {
            for (Class<? extends Throwable> item : exceptionClass) {
                if (item == null) continue;
                classes.add(item);
            }
        }
        if (classes.isEmpty()) {
            classes.add(Exception.class);
        }
        AtomicInteger size = new AtomicInteger(retrySize);
        while (true) {
            try {
                return callable.call();
            }
            catch (Throwable e) {
                if (classes.stream().noneMatch(ex -> ex.isAssignableFrom(e.getClass()))) {
                    throw new RetryException(e.getMessage(), e);
                }
                if (size.decrementAndGet() < 0) {
                    throw new RetryException(e.getMessage(), e);
                }
                if (!intervalTime.isPositive()) continue;
                ThreadUtil.sleep((Duration)intervalTime);
                continue;
            }
            break;
        }
    }
}

