/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.tool.util;

import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.text.StrUtil;

public class Assert {
    public static void notNull(Object object, CharSequence template, Object ... params) {
        if (object == null) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    public static void isNull(Object object, CharSequence template, Object ... params) {
        if (object != null) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    public static void notBlank(CharSequence text, CharSequence template, Object ... params) {
        if (StringUtils.isBlank((CharSequence)text)) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    public static void notEmpty(Object[] arr, CharSequence template, Object ... params) {
        if (arr == null || arr.length == 0) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    public static void notEmpty(Iterable<?> collection, CharSequence template, Object ... params) {
        if (collection == null || !collection.iterator().hasNext()) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    public static void notEmpty(Map<?, ?> map, CharSequence template, Object ... params) {
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    public static void equals(Object a, Object b, CharSequence template, Object ... params) {
        if (!Objects.equals(a, b)) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    public static void isTrue(boolean b, CharSequence template, Object ... params) {
        if (!b) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    public static void isFalse(boolean b, CharSequence template, Object ... params) {
        if (b) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }
}

