/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.tool.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Objects;
import lombok.Generated;
import org.dromara.hutool.core.annotation.AnnotationUtil;
import org.dromara.hutool.core.func.LambdaUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.reflect.FieldUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JacksonUtil.class);
    private static volatile ObjectMapper objectMapper = new ObjectMapper();

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static void setObjectMapper(ObjectMapper objectMapper) {
        Objects.requireNonNull(objectMapper, "objectMapper must not be null");
        JacksonUtil.objectMapper = objectMapper;
    }

    public static <T> T readValue(String content, Class<T> valueType) {
        try {
            return (T)JacksonUtil.getObjectMapper().readValue(content, valueType);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> T readValue(String content, TypeReference<T> valueTypeRef) {
        try {
            return (T)JacksonUtil.getObjectMapper().readValue(content, valueTypeRef);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> T tryReadValue(String content, Class<T> valueType) {
        if (StrUtil.isBlank((CharSequence)content)) {
            return null;
        }
        if (valueType == null) {
            return null;
        }
        try {
            return (T)JacksonUtil.getObjectMapper().readValue(content, valueType);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static <T> T tryReadValue(String content, TypeReference<T> valueTypeRef) {
        if (StrUtil.isBlank((CharSequence)content)) {
            return null;
        }
        if (valueTypeRef == null) {
            return null;
        }
        try {
            return (T)JacksonUtil.getObjectMapper().readValue(content, valueTypeRef);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static String writeValueAsString(Object value) {
        try {
            return JacksonUtil.getObjectMapper().writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String tryWriteValueAsString(Object value) {
        if (value == null) {
            return null;
        }
        try {
            return JacksonUtil.getObjectMapper().writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static byte[] writeValueAsBytes(Object value) {
        try {
            return JacksonUtil.getObjectMapper().writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static byte[] tryWriteValueAsBytes(Object value) {
        try {
            return JacksonUtil.getObjectMapper().writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static <T extends JsonNode> T valueToTree(Object value) {
        return (T)JacksonUtil.getObjectMapper().valueToTree(value);
    }

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return (T)JacksonUtil.getObjectMapper().convertValue(fromValue, toValueType);
    }

    public static <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) {
        return (T)JacksonUtil.getObjectMapper().convertValue(fromValue, toValueTypeRef);
    }

    public static <T extends Serializable> String getAlias(T func) {
        JsonProperty annotation = JacksonUtil.getJsonProperty(func);
        return annotation == null ? LambdaUtil.getFieldName(func) : annotation.value();
    }

    public static String getAlias(Class<?> beanClass, String fieldName) {
        JsonProperty annotation = JacksonUtil.getJsonProperty(beanClass, fieldName);
        if (annotation == null) {
            return FieldUtil.getFieldName((Field)FieldUtil.getField(beanClass, (String)fieldName));
        }
        return annotation.value();
    }

    public static <T extends Serializable> JsonProperty getJsonProperty(T func) {
        Assert.notNull(func, (String)"func must not be null", (Object[])new Object[0]);
        return JacksonUtil.getJsonProperty(LambdaUtil.getRealClass(func), LambdaUtil.getFieldName(func));
    }

    public static JsonProperty getJsonProperty(Class<?> beanClass, String fieldName) {
        Assert.notNull(beanClass, (String)"beanClass must not be null", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)fieldName, (String)"fieldName must not be blank", (Object[])new Object[0]);
        Field field = FieldUtil.getField(beanClass, (String)fieldName);
        if (field == null) {
            return null;
        }
        return (JsonProperty)AnnotationUtil.getAnnotation((AnnotatedElement)field, JsonProperty.class);
    }

    public static JsonNode tryReadTree(String content) {
        try {
            return JacksonUtil.getObjectMapper().readTree(content);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static JsonNode readTree(String content) {
        try {
            return JacksonUtil.getObjectMapper().readTree(content);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static ArrayNode createArrayNode() {
        return JacksonUtil.getObjectMapper().createArrayNode();
    }

    public static ObjectNode createObjectNode() {
        return JacksonUtil.getObjectMapper().createObjectNode();
    }

    public static <T> T treeToValue(TreeNode n, Class<T> valueType) {
        try {
            return (T)JacksonUtil.getObjectMapper().treeToValue(n, valueType);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> T treeToValue(TreeNode n, TypeReference<T> toValueTypeRef) {
        try {
            return (T)JacksonUtil.getObjectMapper().treeToValue(n, toValueTypeRef);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> T treeToValue(TreeNode n, JavaType valueType) {
        try {
            return (T)JacksonUtil.getObjectMapper().treeToValue(n, valueType);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> T tryTreeToValue(TreeNode n, Class<T> valueType) {
        try {
            return (T)JacksonUtil.getObjectMapper().treeToValue(n, valueType);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static <T> T tryTreeToValue(TreeNode n, TypeReference<T> toValueTypeRef) {
        try {
            return (T)JacksonUtil.getObjectMapper().treeToValue(n, toValueTypeRef);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static <T> T tryTreeToValue(TreeNode n, JavaType valueType) {
        try {
            return (T)JacksonUtil.getObjectMapper().treeToValue(n, valueType);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static ObjectNode ofObjectNode(String key, Object value) {
        return (ObjectNode)JacksonUtil.getObjectMapper().createObjectNode().set(key, JacksonUtil.valueToTree(value));
    }

    public static ObjectNode ofObjectNode() {
        return JacksonUtil.getObjectMapper().createObjectNode();
    }

    public static boolean isNull(JsonNode value) {
        return value == null || value.isNull();
    }

    public static boolean isEmpty(JsonNode value) {
        return value == null || value.isNull() || value.isEmpty();
    }
}

