/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.util;

import cn.hutool.v7.core.collection.CollUtil;
import cn.hutool.v7.core.text.split.SplitUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class KeyBuilderUtil {
    private final List<String> values = new ArrayList<String>();

    private KeyBuilderUtil() {
    }

    public KeyBuilderUtil(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.values.addAll(SplitUtil.splitTrim((CharSequence)value, (CharSequence)":"));
        }
    }

    public KeyBuilderUtil(List<String> values) {
        if (CollUtil.isNotEmpty(values)) {
            this.values.addAll(values);
        }
    }

    public KeyBuilderUtil add(String prefix) {
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            this.values.add(prefix);
        }
        return this;
    }

    public static KeyBuilderUtil of(String prefix) {
        return new KeyBuilderUtil(prefix);
    }

    public static KeyBuilderUtil of(List<String> prefixList) {
        return new KeyBuilderUtil(prefixList);
    }

    public String build(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return this.build();
        }
        return this.build() + ":" + value;
    }

    public String build() {
        if (CollUtil.isEmpty(this.values)) {
            throw new RuntimeException("values must not be empty");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.values.size(); ++i) {
            sb.append(this.values.get(i));
            if (i >= this.values.size() - 1) continue;
            sb.append(":");
        }
        return sb.toString();
    }
}

