/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.util;

import cn.hutool.v7.core.func.SerSupplier;
import cn.hutool.v7.core.lang.Singleton;
import cn.hutool.v7.http.HttpGlobalConfig;
import cn.hutool.v7.http.client.ClientConfig;
import cn.hutool.v7.http.client.engine.ClientEngine;
import cn.hutool.v7.http.client.engine.ClientEngineFactory;
import cn.hutool.v7.http.client.engine.jdk.JdkClientEngine;
import java.io.Serializable;
import java.time.Duration;

public class HttpClientUtil {
    public static ClientEngine clientEngine(Class<? extends ClientEngine> clientEngineClass, ClientConfig clientConfig) {
        if (HttpGlobalConfig.getTimeout() <= 0) {
            HttpGlobalConfig.setTimeout((int)Math.toIntExact(Duration.ofSeconds(10L).toMillis()));
        }
        if (clientConfig == null) {
            clientConfig = ClientConfig.of();
        }
        if (clientConfig.getConnectionTimeout() <= 0) {
            clientConfig.setConnectionTimeout(HttpGlobalConfig.getTimeout());
        }
        if (clientConfig.getReadTimeout() <= 0) {
            clientConfig.setReadTimeout(HttpGlobalConfig.getTimeout());
        }
        if (clientEngineClass == null) {
            clientEngineClass = JdkClientEngine.class;
        }
        return ClientEngineFactory.createEngine((String)clientEngineClass.getName()).init(clientConfig);
    }

    public static ClientEngine clientEngine() {
        return (ClientEngine)Singleton.get((String)ClientEngine.class.getName(), (SerSupplier & Serializable)() -> HttpClientUtil.clientEngine(null, null));
    }

    public static void initGlobalConfig(Class<? extends ClientEngine> clientEngineClass) {
        ClientEngine clientEngine = HttpClientUtil.clientEngine(clientEngineClass, null);
        Singleton.put((String)ClientEngine.class.getName(), (Object)clientEngine);
    }

    public static void initGlobalConfig(Class<? extends ClientEngine> clientEngineClass, ClientConfig clientConfig, Duration globalTimeout) {
        if (globalTimeout == null || globalTimeout.toSeconds() <= 0L) {
            globalTimeout = Duration.ofSeconds(10L);
        }
        HttpGlobalConfig.setTimeout((int)Math.toIntExact(globalTimeout.toMillis()));
        ClientEngine clientEngine = HttpClientUtil.clientEngine(clientEngineClass, clientConfig);
        Singleton.put((String)ClientEngine.class.getName(), (Object)clientEngine);
    }
}

