/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.util;

import cn.hutool.v7.core.annotation.AnnotationUtil;
import cn.hutool.v7.core.func.LambdaUtil;
import cn.hutool.v7.core.func.SerFunction;
import cn.hutool.v7.core.lang.Assert;
import cn.hutool.v7.core.reflect.FieldUtil;
import cn.hutool.v7.core.text.StrUtil;
import cn.toint.oktool.exception.JsonException;
import cn.toint.oktool.model.FlexibleLocalDateTimeDeserializer;
import cn.toint.oktool.model.SafeLongSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JacksonUtil.class);
    private static ObjectMapper objectMapper = JacksonUtil.initObjectMapper();

    private static ObjectMapper initObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.registerModules(new Module[]{JacksonUtil.createLocalDateTimeModule(null, null)});
        objectMapper.registerModule(JacksonUtil.createSafeLongModule());
        return objectMapper;
    }

    public static ObjectMapper getObjectMapper() {
        return JacksonUtil.objectMapper();
    }

    public static void setObjectMapper(ObjectMapper objectMapper) {
        JacksonUtil.objectMapper(objectMapper);
    }

    public static void objectMapper(ObjectMapper objectMapper) {
        Objects.requireNonNull(objectMapper, "objectMapper must not be null");
        JacksonUtil.objectMapper = objectMapper;
    }

    public static ObjectMapper objectMapper() {
        return objectMapper;
    }

    public static <T> T readValue(String content, Class<T> valueType) {
        try {
            return (T)JacksonUtil.getObjectMapper().readValue(content, valueType);
        }
        catch (JsonProcessingException e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    public static <T> T readValue(String content, TypeReference<T> valueTypeRef) {
        try {
            return (T)JacksonUtil.getObjectMapper().readValue(content, valueTypeRef);
        }
        catch (JsonProcessingException e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    public static <T> T tryReadValue(String content, Class<T> valueType) {
        if (StrUtil.isBlank((CharSequence)content)) {
            return null;
        }
        if (valueType == null) {
            return null;
        }
        try {
            return (T)JacksonUtil.getObjectMapper().readValue(content, valueType);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static <T> T tryReadValue(String content, TypeReference<T> valueTypeRef) {
        if (StrUtil.isBlank((CharSequence)content)) {
            return null;
        }
        if (valueTypeRef == null) {
            return null;
        }
        try {
            return (T)JacksonUtil.getObjectMapper().readValue(content, valueTypeRef);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static String writeValueAsString(Object value) {
        try {
            return JacksonUtil.getObjectMapper().writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    public static String tryWriteValueAsString(Object value) {
        if (value == null) {
            return null;
        }
        try {
            return JacksonUtil.getObjectMapper().writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static byte[] writeValueAsBytes(Object value) {
        try {
            return JacksonUtil.getObjectMapper().writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    public static byte[] tryWriteValueAsBytes(Object value) {
        try {
            return JacksonUtil.getObjectMapper().writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static <T extends JsonNode> T valueToTree(Object value) {
        return (T)JacksonUtil.getObjectMapper().valueToTree(value);
    }

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return (T)JacksonUtil.getObjectMapper().convertValue(fromValue, toValueType);
    }

    public static <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) {
        return (T)JacksonUtil.getObjectMapper().convertValue(fromValue, toValueTypeRef);
    }

    public static <T extends Serializable> String getAlias(T func) {
        JsonProperty annotation = JacksonUtil.getJsonProperty(func);
        return annotation == null ? LambdaUtil.getFieldName(func) : annotation.value();
    }

    public static <T, R> String getAlias(SerFunction<T, R> func) {
        JsonProperty annotation = JacksonUtil.getJsonProperty(func);
        return annotation == null ? LambdaUtil.getFieldName(func) : annotation.value();
    }

    public static String getAlias(Class<?> beanClass, String fieldName) {
        JsonProperty annotation = JacksonUtil.getJsonProperty(beanClass, fieldName);
        if (annotation == null) {
            return FieldUtil.getFieldName((Field)FieldUtil.getField(beanClass, (String)fieldName));
        }
        return annotation.value();
    }

    public static <T extends Serializable> JsonProperty getJsonProperty(T func) {
        Assert.notNull(func, (String)"func must not be null", (Object[])new Object[0]);
        return JacksonUtil.getJsonProperty(LambdaUtil.getRealClass(func), LambdaUtil.getFieldName(func));
    }

    public static <T, R> JsonProperty getJsonProperty(SerFunction<T, R> func) {
        Assert.notNull(func, (String)"func must not be null", (Object[])new Object[0]);
        return JacksonUtil.getJsonProperty(LambdaUtil.getRealClass(func), LambdaUtil.getFieldName(func));
    }

    public static JsonProperty getJsonProperty(Class<?> beanClass, String fieldName) {
        Assert.notNull(beanClass, (String)"beanClass must not be null", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)fieldName, (String)"fieldName must not be blank", (Object[])new Object[0]);
        Field field = FieldUtil.getField(beanClass, (String)fieldName);
        if (field == null) {
            return null;
        }
        return (JsonProperty)AnnotationUtil.getAnnotation((AnnotatedElement)field, JsonProperty.class);
    }

    public static JsonNode tryReadTree(String content) {
        try {
            return JacksonUtil.getObjectMapper().readTree(content);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static JsonNode readTree(String content) {
        try {
            return JacksonUtil.getObjectMapper().readTree(content);
        }
        catch (JsonProcessingException e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    public static ArrayNode createArrayNode() {
        return JacksonUtil.getObjectMapper().createArrayNode();
    }

    public static ObjectNode createObjectNode() {
        return JacksonUtil.getObjectMapper().createObjectNode();
    }

    public static <T> T treeToValue(TreeNode n, Class<T> valueType) {
        try {
            return (T)JacksonUtil.getObjectMapper().treeToValue(n, valueType);
        }
        catch (JsonProcessingException e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    public static <T> T treeToValue(TreeNode n, TypeReference<T> toValueTypeRef) {
        try {
            return (T)JacksonUtil.getObjectMapper().treeToValue(n, toValueTypeRef);
        }
        catch (JsonProcessingException e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    public static <T> T treeToValue(TreeNode n, JavaType valueType) {
        try {
            return (T)JacksonUtil.getObjectMapper().treeToValue(n, valueType);
        }
        catch (JsonProcessingException e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    public static <T> T tryTreeToValue(TreeNode n, Class<T> valueType) {
        try {
            return (T)JacksonUtil.getObjectMapper().treeToValue(n, valueType);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static <T> T tryTreeToValue(TreeNode n, TypeReference<T> toValueTypeRef) {
        try {
            return (T)JacksonUtil.getObjectMapper().treeToValue(n, toValueTypeRef);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static <T> T tryTreeToValue(TreeNode n, JavaType valueType) {
        try {
            return (T)JacksonUtil.getObjectMapper().treeToValue(n, valueType);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static ObjectNode ofObjectNode(String key, Object value) {
        return (ObjectNode)JacksonUtil.getObjectMapper().createObjectNode().set(key, JacksonUtil.valueToTree(value));
    }

    public static ObjectNode ofObjectNode() {
        return JacksonUtil.getObjectMapper().createObjectNode();
    }

    public static boolean isNull(JsonNode value) {
        return value == null || value.isNull() || value.isMissingNode();
    }

    public static boolean isNotNull(JsonNode value) {
        return !JacksonUtil.isNull(value);
    }

    public static boolean isEmpty(JsonNode value) {
        return JacksonUtil.isNull(value) || value.isEmpty();
    }

    public static boolean isNotEmpty(JsonNode value) {
        return !JacksonUtil.isEmpty(value);
    }

    public static Module createLocalDateTimeModule(@Nullable String pattern, @Nullable ZoneId zoneId) {
        if (StringUtils.isBlank((CharSequence)pattern)) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        if (zoneId == null) {
            zoneId = ZoneId.of("Asia/Shanghai");
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern).withZone(zoneId);
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(dateTimeFormatter));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new FlexibleLocalDateTimeDeserializer());
        return javaTimeModule;
    }

    public static Module createLongModule() {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        return simpleModule;
    }

    public static Module createSafeLongModule() {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Long.class, (JsonSerializer)SafeLongSerializer.instance);
        simpleModule.addSerializer(Long.TYPE, (JsonSerializer)SafeLongSerializer.instance);
        return simpleModule;
    }
}

