/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.util;

import cn.hutool.v7.core.array.ArrayUtil;
import cn.hutool.v7.core.text.StrUtil;
import cn.hutool.v7.extra.validation.ValidationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;

public class Assert {
    @Contract(value="null -> fail")
    public static void notNull(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Contract(value="null, _, _ -> fail")
    public static void notNull(Object object, CharSequence template, Object ... params) {
        if (object == null) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    @Contract(value="!null -> fail")
    public static void isNull(Object object) {
        if (object != null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5fc5\u987b\u4e3a\u7a7a");
        }
    }

    @Contract(value="!null, _, _ -> fail")
    public static void isNull(Object object, CharSequence template, Object ... params) {
        if (object != null) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    @Contract(value="null -> fail")
    public static void notBlank(CharSequence text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Contract(value="null, _, _ -> fail")
    public static void notBlank(CharSequence text, CharSequence template, Object ... params) {
        if (StringUtils.isBlank((CharSequence)text)) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    @Contract(value="null -> fail")
    public static void notEmpty(Object[] arr) {
        if (arr == null || arr.length == 0) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Contract(value="null, _, _ -> fail")
    public static void notEmpty(Object[] arr, CharSequence template, Object ... params) {
        if (arr == null || arr.length == 0) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    @Contract(value="null -> fail")
    public static void notEmpty(Iterable<?> collection) {
        if (collection == null || !collection.iterator().hasNext()) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Contract(value="null, _, _ -> fail")
    public static void notEmpty(Iterable<?> collection, CharSequence template, Object ... params) {
        if (collection == null || !collection.iterator().hasNext()) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    @Contract(value="null, _, _ -> fail")
    public static void notEmpty(Map<?, ?> map, CharSequence template, Object ... params) {
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    public static void equals(Object a, Object b, CharSequence template, Object ... params) {
        if (!Objects.equals(a, b)) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    public static void notEquals(Object a, Object b, CharSequence template, Object ... params) {
        if (Objects.equals(a, b)) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    @Contract(value="false, _, _ -> fail")
    public static void isTrue(boolean b, CharSequence template, Object ... params) {
        if (!b) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    @Contract(value="true, _, _ -> fail")
    public static void isFalse(boolean b, CharSequence template, Object ... params) {
        if (b) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
    }

    @Contract(value="null, _ -> fail")
    public static void validate(Object object, Class<?> ... groups) {
        Assert.notNull(object);
        ValidationUtil.validateAndThrowFirst((Object)object, (Class[])groups);
    }

    @Contract(value="null, _, _ -> fail")
    public static void validate(Object object, CharSequence template, Object ... params) {
        if (object == null) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])params));
        }
        try {
            ValidationUtil.validateAndThrowFirst((Object)object, (Class[])new Class[0]);
        }
        catch (Exception e) {
            if (StringUtils.isBlank((CharSequence)template)) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            ArrayList<Object> newParams = new ArrayList<Object>();
            if (ArrayUtil.isNotEmpty((Object[])params)) {
                newParams.addAll(Arrays.asList(params));
            }
            newParams.add(e.getMessage());
            throw new IllegalArgumentException(StrUtil.format((CharSequence)template, (Object[])newParams.toArray()), e);
        }
    }
}

