/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.util;

import cn.toint.oktool.util.Assert;
import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.HashMap;
import java.util.Map;
import org.dromara.hutool.core.data.id.IdUtil;
import org.slf4j.MDC;

public class MdcUtil {
    private static final String TRACE_ID = "traceId";
    private static TransmittableThreadLocal<Map<String, String>> ttlMdc;

    public static void initTraceId() {
        MdcUtil.put(TRACE_ID, IdUtil.fastSimpleUUID());
    }

    public static String getTraceId() {
        return MdcUtil.get(TRACE_ID);
    }

    public static void put(String key, String value) {
        Assert.notBlank(key, "key\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        ((Map)ttlMdc.get()).put(key, value);
        MDC.put((String)key, (String)value);
    }

    public static String get(String key) {
        Assert.notBlank(key, "key\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        String value = MDC.get((String)key);
        if (value != null) {
            return value;
        }
        return (String)((Map)ttlMdc.get()).get(key);
    }

    public static void remove(String key) {
        ((Map)ttlMdc.get()).remove(key);
        MDC.remove((String)key);
    }

    public static void clear() {
        ((Map)ttlMdc.get()).clear();
        ttlMdc.remove();
        MDC.clear();
    }

    private static void init() {
        ttlMdc = new TransmittableThreadLocal<Map<String, String>>(){

            protected Map<String, String> initialValue() {
                return new HashMap<String, String>();
            }

            protected void beforeExecute() {
                Map map = (Map)this.get();
                map.forEach(MDC::put);
            }

            protected void afterExecute() {
                MDC.clear();
            }
        };
    }

    static {
        MdcUtil.init();
    }
}

