/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.util;

import cn.toint.oktool.util.Assert;
import jakarta.annotation.Nonnull;
import java.util.concurrent.TimeUnit;
import org.dromara.hutool.extra.spring.SpringUtil;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisLockUtil {
    public static boolean lock(@Nonnull String key, long timeout) {
        return RedisLockUtil.lock(key, timeout, TimeUnit.MILLISECONDS);
    }

    public static boolean lock(@Nonnull String key, long timeout, @Nonnull TimeUnit unit) {
        Assert.notBlank(key, "key must not be blank", new Object[0]);
        Assert.notNull((Object)unit, "unit must not be null", new Object[0]);
        Assert.isTrue(timeout > 0L, "timeout \u5fc5\u987b\u5927\u4e8e 0", new Object[0]);
        Boolean setIfAbsent = ((StringRedisTemplate)SpringUtil.getBean(StringRedisTemplate.class, (Object[])new Object[0])).opsForValue().setIfAbsent((Object)key, (Object)"", timeout, unit);
        return Boolean.TRUE.equals(setIfAbsent);
    }

    public static void unlock(@Nonnull String key) {
        Assert.notBlank(key, "key must not be blank", new Object[0]);
        ((StringRedisTemplate)SpringUtil.getBean(StringRedisTemplate.class, (Object[])new Object[0])).delete((Object)key);
    }
}

