/*
 * Copyright 2025 Toint (599818663@qq.com)
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.toint.oktool.service;

import java.time.Duration;

/**
 * 缓存服务
 *
 * @author Toint
 * @date 2025/7/2
 */
public interface CacheService {
    /**
     * 设置缓存
     *
     * @param key     缓存键, 不能为空
     * @param value   缓存值
     * @param timeout 缓存时间, 不能为空
     */
    void put(String key, String value, Duration timeout);

    /**
     * 获取缓存
     *
     * @param key     缓存键
     */
    String get(String key);
}
