/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.spring.boot.util;

import cn.hutool.v7.core.collection.CollUtil;
import cn.hutool.v7.core.io.file.FileUtil;
import cn.hutool.v7.core.io.resource.Resource;
import cn.hutool.v7.core.io.resource.ResourceUtil;
import cn.hutool.v7.core.text.CharSequenceUtil;
import cn.hutool.v7.core.text.split.SplitUtil;
import cn.toint.oktool.util.Assert;
import com.mybatisflex.core.datasource.DataSourceKey;
import com.mybatisflex.core.row.Db;
import com.mybatisflex.core.util.SqlUtil;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlScriptUtil {
    private static final Logger log = LoggerFactory.getLogger(SqlScriptUtil.class);

    public static int execute(String dataSourceKey, String sqlDir, Comparator<? super File> comparator, FileFilter fileFilter) {
        Assert.notBlank((CharSequence)dataSourceKey, (CharSequence)"dataSourceKey must not be null", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)sqlDir, (CharSequence)"dir must not be null", (Object[])new Object[0]);
        Assert.isTrue((boolean)FileUtil.isDirectory((String)sqlDir), (CharSequence)"dir must be a directory", (Object[])new Object[0]);
        Resource resource = ResourceUtil.getResource((String)sqlDir);
        List files = Optional.ofNullable(resource.getUrl()).map(URL::getPath).map(path -> FileUtil.loopFiles((String)path, (FileFilter)fileFilter)).orElseThrow(() -> new RuntimeException("\u65e0\u6cd5\u8bfb\u53d6\u6587\u4ef6\u8d44\u6e90"));
        return SqlScriptUtil.execute(dataSourceKey, files, comparator);
    }

    public static int execute(String dataSourceKey, List<File> files, Comparator<? super File> comparator) {
        Assert.notBlank((CharSequence)dataSourceKey, (CharSequence)"dataSourceKey must not be null", (Object[])new Object[0]);
        if (CollUtil.isEmpty(files)) {
            return 0;
        }
        if (comparator != null) {
            files.sort(comparator);
        }
        ArrayList<String> sql = new ArrayList<String>();
        files.forEach(item -> {
            if (!FileUtil.exists((File)item)) {
                return;
            }
            String fileStr = FileUtil.readUtf8String((File)item);
            if (StringUtils.isBlank((CharSequence)fileStr)) {
                return;
            }
            sql.addAll(SplitUtil.split((CharSequence)fileStr, (CharSequence)";"));
        });
        return SqlScriptUtil.execute(dataSourceKey, sql);
    }

    public static int execute(String dataSourceKey, List<String> sql) {
        Assert.notBlank((CharSequence)dataSourceKey, (CharSequence)"dataSourceKey must not be null", (Object[])new Object[0]);
        if (CollUtil.isEmpty(sql)) {
            return 0;
        }
        AtomicInteger successSize = new AtomicInteger();
        sql.stream().map(CharSequenceUtil::removeAllLineBreaks).forEach(item -> {
            if (StringUtils.isBlank((CharSequence)item)) {
                return;
            }
            try {
                DataSourceKey.use((String)dataSourceKey, () -> {
                    if (SqlUtil.toBool((int)Db.updateBySql((String)item, (Object[])new Object[0]))) {
                        successSize.incrementAndGet();
                    }
                });
            }
            catch (Exception e) {
                log.error("SQL\u6267\u884c\u5931\u8d25: {}", (Object)e.getMessage());
            }
        });
        return successSize.get();
    }
}

