/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.spring.boot.trace;

import cn.hutool.v7.core.data.id.IdUtil;
import cn.hutool.v7.http.server.servlet.ServletUtil;
import cn.toint.oktool.spring.boot.context.OkContext;
import cn.toint.oktool.spring.boot.trace.TraceInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.HandlerInterceptor;

public class TraceInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TraceInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String traceId = IdUtil.fastSimpleUUID();
        OkContext.setTraceId(traceId);
        TraceInfo traceInfo = new TraceInfo();
        traceInfo.setTraceId(traceId);
        traceInfo.setMethod(request.getMethod());
        traceInfo.setUri(request.getRequestURI());
        traceInfo.setQuery(request.getQueryString());
        traceInfo.setClientIp(ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
        traceInfo.setUserAgent(this.getUserAgent(request));
        traceInfo.setStartTime(LocalDateTime.now());
        OkContext.setTraceInfo(traceInfo);
        log.info("\u8bf7\u6c42\u5f00\u59cb: {}", (Object)traceInfo.toJsonString());
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable Exception ex) throws Exception {
        TraceInfo traceInfo = OkContext.getTraceInfo();
        if (traceInfo != null) {
            traceInfo.setStatus(response.getStatus());
            traceInfo.setEndTime(LocalDateTime.now());
            traceInfo.calculateDuration();
            log.info("\u8bf7\u6c42\u7ed3\u675f: {}", (Object)traceInfo.toJsonString());
        }
    }

    private String getUserAgent(HttpServletRequest request) {
        return request.getHeader("User-Agent");
    }
}

