/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.spring.boot.trace;

import cn.hutool.v7.core.date.TimeUtil;
import cn.toint.oktool.model.WriteValue;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;

public class TraceInfo
implements WriteValue {
    private String traceId;
    private String method;
    private String uri;
    private String query;
    private String clientIp;
    private String userAgent;
    private Integer status;
    private LocalDateTime startTime;
    private LocalDateTime endTime;
    private Long duration;
    private Boolean slow;
    private Object userId;
    private String token;

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TraceInfo traceInfo = (TraceInfo)object;
        return Objects.equals(this.traceId, traceInfo.traceId) && Objects.equals(this.method, traceInfo.method) && Objects.equals(this.uri, traceInfo.uri) && Objects.equals(this.query, traceInfo.query) && Objects.equals(this.clientIp, traceInfo.clientIp) && Objects.equals(this.userAgent, traceInfo.userAgent) && Objects.equals(this.status, traceInfo.status) && Objects.equals(this.startTime, traceInfo.startTime) && Objects.equals(this.endTime, traceInfo.endTime) && Objects.equals(this.duration, traceInfo.duration) && Objects.equals(this.slow, traceInfo.slow) && Objects.equals(this.userId, traceInfo.userId) && Objects.equals(this.token, traceInfo.token);
    }

    public int hashCode() {
        return Objects.hash(this.traceId, this.method, this.uri, this.query, this.clientIp, this.userAgent, this.status, this.startTime, this.endTime, this.duration, this.slow, this.userId, this.token);
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public Boolean getSlow() {
        return this.slow;
    }

    public void setSlow(Boolean slow) {
        this.slow = slow;
    }

    public Object getUserId() {
        return this.userId;
    }

    public void setUserId(Object userId) {
        this.userId = userId;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Long calculateDuration() {
        LocalDateTime startTime = this.getStartTime();
        LocalDateTime endTime = this.getEndTime();
        if (startTime != null && endTime != null) {
            long duration = TimeUtil.between((LocalDateTime)startTime, (LocalDateTime)endTime, (ChronoUnit)ChronoUnit.MILLIS);
            this.setDuration(duration);
            this.setSlow(duration >= 3000L);
            return duration;
        }
        return null;
    }
}

