/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.spring.boot.satoken;

import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.exception.NotPermissionException;
import cn.dev33.satoken.exception.NotRoleException;
import cn.toint.oktool.model.ErrCode;
import cn.toint.oktool.model.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;

public class SaTokenExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(SaTokenExceptionHandler.class);

    @ExceptionHandler(value={NotLoginException.class})
    public Response<Void> notLoginException(NotLoginException e) {
        log.warn(e.getMessage());
        return Response.fail((int)ErrCode.NOT_LOGIN.getCode(), (String)ErrCode.NOT_LOGIN.getMsg());
    }

    @ExceptionHandler(value={NotPermissionException.class})
    public Response<Void> notPermissionException(NotPermissionException e) {
        log.warn(e.getMessage());
        return Response.fail((int)ErrCode.NOT_PERMISSION.getCode(), (String)ErrCode.NOT_PERMISSION.getMsg());
    }

    @ExceptionHandler(value={NotRoleException.class})
    public Response<Void> exception(NotRoleException e) {
        log.error(e.getMessage());
        return Response.fail((int)ErrCode.NOT_PERMISSION.getCode(), (String)ErrCode.NOT_PERMISSION.getMsg());
    }
}

