/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.spring.boot.model;

import cn.hutool.v7.core.data.id.IdUtil;
import com.mybatisflex.annotation.Column;
import com.mybatisflex.annotation.Id;
import java.time.LocalDateTime;
import java.util.Objects;

public class BaseDo {
    @Id
    private Long id;
    @Column
    private LocalDateTime createTime;
    @Column
    private LocalDateTime updateTime;

    public BaseDo init() {
        this.initId().initCreateTime().initUpdateTime();
        return this;
    }

    public BaseDo initId() {
        if (this.id == null) {
            this.setId(IdUtil.getSnowflakeNextId());
        }
        return this;
    }

    public BaseDo initCreateAndUpdateTime() {
        this.initCreateTime();
        this.initUpdateTime();
        return this;
    }

    public BaseDo initCreateTime() {
        if (this.createTime == null) {
            this.setCreateTime(LocalDateTime.now());
        }
        return this;
    }

    public BaseDo initUpdateTime() {
        this.freshUpdateTime();
        return this;
    }

    public BaseDo freshUpdateTime() {
        this.setUpdateTime(LocalDateTime.now());
        return this;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public LocalDateTime getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseDo baseDo = (BaseDo)o;
        return Objects.equals(this.id, baseDo.id) && Objects.equals(this.createTime, baseDo.createTime) && Objects.equals(this.updateTime, baseDo.updateTime);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createTime, this.updateTime);
    }

    public String toString() {
        return "BaseDo{id=" + this.id + ", createTime=" + String.valueOf(this.createTime) + ", updateTime=" + String.valueOf(this.updateTime) + "}";
    }
}

