/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.spring.boot.jakcson;

import java.util.Objects;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="oktool.jackson")
public class JacksonProperties {
    private LocalDateTimeModule localDateTimeModule = new LocalDateTimeModule();
    private SafeLongModule safeLongModule = new SafeLongModule();

    public LocalDateTimeModule getLocalDateTimeModule() {
        return this.localDateTimeModule;
    }

    public void setLocalDateTimeModule(LocalDateTimeModule localDateTimeModule) {
        this.localDateTimeModule = localDateTimeModule;
    }

    public SafeLongModule getSafeLongModule() {
        return this.safeLongModule;
    }

    public void setSafeLongModule(SafeLongModule safeLongModule) {
        this.safeLongModule = safeLongModule;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JacksonProperties that = (JacksonProperties)o;
        return Objects.equals(this.localDateTimeModule, that.localDateTimeModule) && Objects.equals(this.safeLongModule, that.safeLongModule);
    }

    public int hashCode() {
        return Objects.hash(this.localDateTimeModule, this.safeLongModule);
    }

    public String toString() {
        return "JacksonProperties{localDateTimeModule=" + String.valueOf(this.localDateTimeModule) + ", safeLongModule=" + String.valueOf(this.safeLongModule) + "}";
    }

    public static class LocalDateTimeModule {
        private boolean enabled = true;
        private String zoneId = "Asia/Shanghai";
        private String pattern = "yyyy-MM-dd HH:mm:ss";

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getZoneId() {
            return this.zoneId;
        }

        public void setZoneId(String zoneId) {
            this.zoneId = zoneId;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalDateTimeModule that = (LocalDateTimeModule)o;
            return this.enabled == that.enabled && Objects.equals(this.zoneId, that.zoneId) && Objects.equals(this.pattern, that.pattern);
        }

        public int hashCode() {
            return Objects.hash(this.enabled, this.zoneId, this.pattern);
        }

        public String toString() {
            return "LocalDateTimeModule{enabled=" + this.enabled + ", zoneId='" + this.zoneId + "', pattern='" + this.pattern + "'}";
        }
    }

    public static class SafeLongModule {
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SafeLongModule that = (SafeLongModule)o;
            return this.enabled == that.enabled;
        }

        public int hashCode() {
            return Objects.hashCode(this.enabled);
        }

        public String toString() {
            return "SafeLongModule{enabled=" + this.enabled + "}";
        }
    }
}

