/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.spring.boot.flyway.service;

import com.mybatisflex.core.datasource.FlexDataSource;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.util.Map;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlywayService {
    private static final Logger log = LoggerFactory.getLogger(FlywayService.class);
    @Resource
    private DataSource dataSource;

    @PostConstruct
    private void init() {
        Map dataSourceMap = ((FlexDataSource)this.dataSource).getDataSourceMap();
        dataSourceMap.forEach((dataSourceKey, dataSourceInstance) -> {
            if (dataSourceInstance == null) {
                return;
            }
            Flyway.configure().dataSource(dataSourceInstance).baselineOnMigrate(true).locations(new String[]{"db/migration/" + dataSourceKey}).load().migrate();
            log.info("\u6570\u636e\u5e93\u8fc1\u79fb\u4efb\u52a1\u521d\u59cb\u5316\u6210\u529f, dataSourceKey: {}", dataSourceKey);
        });
    }
}

