/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.spring.boot.flextenant;

import cn.dev33.satoken.stp.StpUtil;
import cn.toint.oktool.spring.boot.flextenant.FlexTenantFactory;
import cn.toint.oktool.spring.boot.flextenant.FlexTenantInterceptor;
import com.mybatisflex.core.tenant.TenantFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration
@ConditionalOnClass(value={StpUtil.class, FlexTenantFactory.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class FlexTenantAutoConfig
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(FlexTenantAutoConfig.class);

    public void addInterceptors(InterceptorRegistry registry) {
        int order = -980;
        registry.addInterceptor((HandlerInterceptor)new FlexTenantInterceptor()).addPathPatterns(new String[]{"/**"}).order(order);
        log.info("FlexTenantInterceptor-\u79df\u6237\u62e6\u622a\u5668\u5df2\u5f00\u542f. path: /**, order: {}", (Object)order);
    }

    @Bean
    @ConditionalOnMissingBean
    public TenantFactory tenantFactory() {
        log.info("TenantFactory-\u591a\u79df\u6237\u529f\u80fd\u5df2\u5f00\u542f");
        return new FlexTenantFactory();
    }
}

