/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.spring.boot.context;

import cn.hutool.v7.http.meta.ContentType;
import cn.hutool.v7.http.server.servlet.ServletUtil;
import cn.toint.oktool.model.ErrCode;
import cn.toint.oktool.model.Response;
import cn.toint.oktool.spring.boot.context.OkContext;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkContextFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(OkContextFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        OkContext.runWithNewContext(() -> {
            try {
                chain.doFilter(request, response);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                OkContextFilter.writeErrMsg(httpServletResponse, ErrCode.FAIL);
            }
        });
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        log.info("OkContextFilter-\u4e0a\u4e0b\u6587\u8fc7\u6ee4\u5668\u521d\u59cb\u5316\u6210\u529f (\u57fa\u4e8eScopedValue)");
    }

    private static void writeErrMsg(HttpServletResponse response, ErrCode errCode) {
        String errMsg = Response.fail((int)errCode.getCode(), (String)errCode.getMsg()).toJsonString();
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentLength(errMsg.getBytes().length);
        ServletUtil.write((HttpServletResponse)response, (String)errMsg, (String)ContentType.JSON.getValue());
    }
}

