/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.spring.boot.context;

import cn.hutool.v7.core.collection.CollUtil;
import cn.toint.oktool.spring.boot.trace.TraceInfo;
import cn.toint.oktool.util.Assert;
import cn.toint.oktool.util.ScopedValueUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;

public class OkContext {
    private static final ScopedValue<Map<String, Object>> CONTEXT_INSTANCE = ScopedValue.newInstance();
    private static final String TENANT_ID_NAME = "tenantId";
    private static final String TRACE_ID_NAME = "traceId";
    private static final String TRACE_INFO_NAME = "traceInfo";
    private static final String TOKEN_NAME = "token";

    public static boolean hasContext() {
        return CONTEXT_INSTANCE.isBound() && CONTEXT_INSTANCE.get() != null;
    }

    public static void checkContext() {
        if (!OkContext.hasContext()) {
            throw new RuntimeException("OkContext\u4e0a\u4e0b\u6587\u5c1a\u672a\u521d\u59cb\u5316");
        }
    }

    public static Map<String, Object> getContext() {
        OkContext.checkContext();
        return CONTEXT_INSTANCE.get();
    }

    public static <V> V get(String key) {
        Assert.notBlankParam((CharSequence)key, (CharSequence)"key");
        if (OkContext.hasContext()) {
            return (V)OkContext.getContext().get(key);
        }
        return null;
    }

    public static <V> V getOrDefault(String key, V defaultValue) {
        V value = OkContext.get(key);
        return value != null ? value : defaultValue;
    }

    public static <V> void put(String key, V value) {
        Assert.notBlankParam((CharSequence)key, (CharSequence)"key");
        Assert.notNullParam(value, (CharSequence)"value");
        OkContext.getContext().put(key, value);
    }

    public static void delete(String key) {
        Assert.notBlankParam((CharSequence)key, (CharSequence)"key");
        if (OkContext.hasContext()) {
            OkContext.getContext().remove(key);
        }
    }

    public static void runWithNewContext(Runnable runnable) {
        ScopedValue.where(CONTEXT_INSTANCE, new ConcurrentHashMap()).run(runnable);
    }

    public static <R> R callWithNewContext(Supplier<R> supplier) {
        return (R)ScopedValue.where(CONTEXT_INSTANCE, new ConcurrentHashMap()).call(supplier::get);
    }

    public static void runWithContext(Map<String, Object> context, Runnable runnable) {
        Assert.notNullParam((Object)runnable, (CharSequence)"runnable");
        OkContext.callWithContext(context, () -> {
            runnable.run();
            return null;
        });
    }

    public static <R> R callWithContext(Map<String, Object> context, Supplier<R> supplier) {
        Assert.notNullParam(supplier, (CharSequence)"supplier");
        context = context == null ? new ConcurrentHashMap<String, Object>() : new ConcurrentHashMap<String, Object>(context);
        return (R)ScopedValue.where(CONTEXT_INSTANCE, context).call(supplier::get);
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable) {
        Assert.notNullParam((Object)runnable, (CharSequence)"runnable");
        return OkContext.supplyAsync(() -> {
            runnable.run();
            return null;
        });
    }

    public static <T> CompletableFuture<T> supplyAsync(Supplier<T> supplier) {
        Assert.notNullParam(supplier, (CharSequence)"supplier");
        ConcurrentHashMap<Object, Object> context = OkContext.hasContext() ? new ConcurrentHashMap<String, Object>(OkContext.getContext()) : new ConcurrentHashMap();
        return ScopedValueUtil.supplyAsync(Map.of(CONTEXT_INSTANCE, context), supplier);
    }

    public static Object getTenantIdNotNull() {
        Object tenantId = OkContext.getTenantId();
        Assert.notNullParam((Object)tenantId, (CharSequence)"\u79df\u6237ID");
        return tenantId;
    }

    public static Object getTenantId() {
        List<Object> tenantIds = OkContext.getTenantIds();
        return CollUtil.isEmpty(tenantIds) ? null : tenantIds.getFirst();
    }

    public static List<Object> getTenantIds() {
        return OkContext.getOrDefault(TENANT_ID_NAME, List.of());
    }

    public static void setTenantId(Object tenantId) {
        OkContext.setTenantIds(tenantId == null ? null : List.of(tenantId));
    }

    public static void setTenantIds(List<Object> tenantIds) {
        tenantIds = CollUtil.isEmpty(tenantIds) ? List.of() : tenantIds.stream().filter(Objects::nonNull).toList();
        OkContext.put(TENANT_ID_NAME, tenantIds);
    }

    public static <T> T callWithTenantId(Object tenantId, Supplier<T> supplier) {
        return OkContext.callWithTenantIds(Collections.singletonList(tenantId), supplier);
    }

    public static <T> T callWithTenantIds(List<Object> tenantIds, Supplier<T> supplier) {
        Assert.notNullParam(supplier, (CharSequence)"supplier");
        return (T)OkContext.callWithContext(OkContext.hasContext() ? OkContext.getContext() : null, () -> {
            OkContext.setTenantIds(tenantIds);
            return supplier.get();
        });
    }

    public static void setTraceId(String traceId) {
        Assert.notBlankParam((CharSequence)traceId, (CharSequence)TRACE_ID_NAME);
        MDC.put((String)TRACE_ID_NAME, (String)traceId);
        OkContext.put(TRACE_ID_NAME, traceId);
    }

    public static String getTraceId() {
        String value = MDC.get((String)TRACE_ID_NAME);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        return (String)OkContext.get(TRACE_ID_NAME);
    }

    public static void setTraceInfo(TraceInfo traceInfo) {
        Assert.notNullParam((Object)traceInfo, (CharSequence)TRACE_INFO_NAME);
        OkContext.put(TRACE_INFO_NAME, traceInfo);
    }

    public static TraceInfo getTraceInfo() {
        return (TraceInfo)OkContext.get(TRACE_INFO_NAME);
    }

    public static void setToken(String token) {
        Assert.notBlankParam((CharSequence)token, (CharSequence)TOKEN_NAME);
        OkContext.put(TOKEN_NAME, token);
    }

    public static String getToken() {
        return (String)OkContext.get(TOKEN_NAME);
    }
}

