/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.spring.boot.cache.impl;

import cn.hutool.v7.core.date.DateUtil;
import cn.hutool.v7.core.date.TimeUtil;
import cn.toint.oktool.spring.boot.cache.Cache;
import cn.toint.oktool.util.Assert;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisCacheImpl
implements Cache {
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public void put(String key, String value, long timeout) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean putIfAbsent(String key, String value, long timeout) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Boolean status = this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, timeout, TimeUnit.MILLISECONDS);
        return Objects.equals(Boolean.TRUE, status);
    }

    @Override
    public String get(String key) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return (String)this.stringRedisTemplate.opsForValue().get((Object)key);
    }

    @Override
    public List<String> multiGet(Collection<String> keys) {
        Assert.notEmpty(keys, (CharSequence)"keys\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.stringRedisTemplate.opsForValue().multiGet(keys);
    }

    @Override
    public boolean containsKey(String key) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Boolean hasKey = this.stringRedisTemplate.hasKey((Object)key);
        return Objects.equals(Boolean.TRUE, hasKey);
    }

    @Override
    public void delete(String key) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.stringRedisTemplate.delete((Object)key);
    }

    @Override
    public long add(String key, long delta) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long valueNum = this.stringRedisTemplate.opsForValue().increment((Object)key, delta);
        Assert.notNull((Object)valueNum, (CharSequence)"Redis \u64cd\u4f5c\u5931\u8d25", (Object[])new Object[0]);
        return valueNum;
    }

    @Override
    public double add(String key, double delta) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Double valueNum = this.stringRedisTemplate.opsForValue().increment((Object)key, delta);
        Assert.notNull((Object)valueNum, (CharSequence)"Redis \u64cd\u4f5c\u5931\u8d25", (Object[])new Object[0]);
        return valueNum;
    }

    @Override
    public void expire(String key, long timeout) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (timeout <= 0L) {
            this.stringRedisTemplate.delete((Object)key);
        } else {
            this.stringRedisTemplate.expire((Object)key, timeout, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void expireAt(String key, LocalDateTime timeout) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)timeout, (CharSequence)"\u8fc7\u671f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (TimeUtil.now().isAfter(timeout)) {
            this.stringRedisTemplate.delete((Object)key);
        } else {
            this.stringRedisTemplate.expireAt((Object)key, (Date)DateUtil.date((TemporalAccessor)timeout));
        }
    }
}

