/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.spring.boot.cache.impl;

import cn.hutool.v7.core.cache.impl.TimedCache;
import cn.hutool.v7.core.date.TimeUtil;
import cn.toint.oktool.spring.boot.cache.Cache;
import cn.toint.oktool.util.Assert;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class LocalCacheImpl
implements Cache {
    private final TimedCache<String, String> timedCache = this.initTimedCache();
    private final ReentrantLock lock = new ReentrantLock();

    @Override
    public void put(String key, String value, long timeout) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.timedCache.put((Object)key, (Object)value, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putIfAbsent(String key, String value, long timeout) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.lock.lock();
        try {
            if (this.containsKey(key)) {
                boolean bl = false;
                return bl;
            }
            this.put(key, value, timeout);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String get(String key) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return (String)this.timedCache.get((Object)key, false);
    }

    @Override
    public List<String> multiGet(Collection<String> keys) {
        Assert.notEmpty(keys, (CharSequence)"keys\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList<String> values = new ArrayList<String>();
        for (String key : keys) {
            values.add(this.get(key));
        }
        return values;
    }

    @Override
    public boolean containsKey(String key) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.timedCache.containsKey((Object)key);
    }

    @Override
    public void delete(String key) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.timedCache.remove((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long add(String key, long delta) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.lock.lock();
        try {
            String valueStr = this.get(key);
            long valueNum = valueStr == null ? 0L : Long.parseLong(valueStr);
            this.put(key, String.valueOf(valueNum += delta), 0L);
            long l = valueNum;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double add(String key, double delta) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.lock.lock();
        try {
            String valueStr = this.get(key);
            double valueNum = valueStr == null ? 0.0 : Double.parseDouble(valueStr);
            this.put(key, String.valueOf(valueNum += delta), 0L);
            double d = valueNum;
            return d;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expire(String key, long timeout) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.lock.lock();
        try {
            if (timeout <= 0L) {
                this.delete(key);
                return;
            }
            String value = this.get(key);
            if (value != null) {
                this.put(key, value, timeout);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void expireAt(String key, LocalDateTime timeout) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)timeout, (CharSequence)"\u8fc7\u671f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        long between = TimeUtil.between((LocalDateTime)TimeUtil.now(), (LocalDateTime)timeout, (ChronoUnit)ChronoUnit.MILLIS);
        this.expire(key, between);
    }

    private TimedCache<String, String> initTimedCache() {
        TimedCache timedCache = new TimedCache(0L);
        timedCache.schedulePrune(60000L);
        return timedCache;
    }
}

