/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.spring.boot.cache;

import cn.toint.oktool.spring.boot.cache.Cache;
import cn.toint.oktool.spring.boot.cache.CacheProperties;
import cn.toint.oktool.spring.boot.cache.impl.LocalCacheImpl;
import cn.toint.oktool.spring.boot.cache.impl.RedisCacheImpl;
import jakarta.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.ClassUtils;

@AutoConfiguration
@EnableConfigurationProperties(value={CacheProperties.class})
public class CacheAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(CacheAutoConfig.class);
    @Resource
    private CacheProperties cacheProperties;

    @Bean
    @ConditionalOnMissingBean
    public Cache cacheService() {
        CacheProperties.Type cacheType = this.cacheProperties.getType();
        if (cacheType == null) {
            cacheType = CacheProperties.Type.AUTO;
        }
        Cache cache = cacheType == CacheProperties.Type.AUTO && ClassUtils.isPresent((String)"org.springframework.data.redis.core.StringRedisTemplate", null) ? new RedisCacheImpl() : (cacheType == CacheProperties.Type.REDIS ? new RedisCacheImpl() : new LocalCacheImpl());
        log.info("Cache\u7f13\u5b58\u670d\u52a1\u521d\u59cb\u5316\u6210\u529f, \u5b9e\u73b0\u7c7b: {}", (Object)cache.getClass().getSimpleName());
        return cache;
    }
}

