/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.spring.boot.cache;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;

public interface Cache {
    default public void put(String key, String value, Duration timeout) {
        this.put(key, value, timeout.toMillis());
    }

    public void put(String var1, String var2, long var3);

    default public boolean putIfAbsent(String key, String value, Duration timeout) {
        return this.putIfAbsent(key, value, timeout.toMillis());
    }

    public boolean putIfAbsent(String var1, String var2, long var3);

    public String get(String var1);

    public List<String> multiGet(Collection<String> var1);

    public boolean containsKey(String var1);

    public void delete(String var1);

    public long add(String var1, long var2);

    public double add(String var1, double var2);

    default public long increment(String key) {
        return this.add(key, 1L);
    }

    default public long increment(String key, long delta) {
        return this.add(key, delta);
    }

    default public double increment(String key, double delta) {
        return this.add(key, delta);
    }

    default public long decrement(String key) {
        return this.add(key, -1L);
    }

    default public long decrement(String key, long delta) {
        return this.add(key, -delta);
    }

    default public double decrement(String key, double delta) {
        return this.add(key, -delta);
    }

    default public void expire(String key, Duration timeout) {
        this.expire(key, timeout.toMillis());
    }

    public void expire(String var1, long var2);

    public void expireAt(String var1, LocalDateTime var2);
}

