/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.spring.boot.bdocr.util;

import cn.hutool.v7.core.text.StrUtil;
import cn.toint.oktool.spring.boot.bdocr.model.InvoiceVerifyType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class InvoiceTypeConverter {
    private static final Map<String, InvoiceVerifyType> OCR_TO_VERIFY_TYPE_MAP = new HashMap<String, InvoiceVerifyType>();

    public static InvoiceVerifyType convertOcrToVerifyType(String ocrResult) {
        if (StringUtils.isBlank((CharSequence)(ocrResult = StrUtil.trim((CharSequence)ocrResult)))) {
            return null;
        }
        return OCR_TO_VERIFY_TYPE_MAP.get(ocrResult);
    }

    public static InvoiceVerifyType convertOcrToVerifyTypeNotNull(String ocrResult) {
        return Optional.ofNullable(InvoiceTypeConverter.convertOcrToVerifyType(ocrResult)).orElse(InvoiceVerifyType.UNKNOWN);
    }

    static {
        for (InvoiceVerifyType value : InvoiceVerifyType.values()) {
            String code = value.getCode();
            OCR_TO_VERIFY_TYPE_MAP.put(code.toLowerCase(), value);
            OCR_TO_VERIFY_TYPE_MAP.put(code.toUpperCase(), value);
            OCR_TO_VERIFY_TYPE_MAP.put(value.getDescription(), value);
        }
        OCR_TO_VERIFY_TYPE_MAP.put("\u666e\u7968", InvoiceVerifyType.NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u666e\u901a\u53d1\u7968", InvoiceVerifyType.NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968", InvoiceVerifyType.NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u589e\u503c\u7a0e\u666e\u7968", InvoiceVerifyType.NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u589e\u666e\u7968", InvoiceVerifyType.NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7eb8\u8d28\u666e\u901a\u53d1\u7968", InvoiceVerifyType.NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u4e13\u7968", InvoiceVerifyType.SPECIAL_VAT_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u4e13\u7528\u53d1\u7968", InvoiceVerifyType.SPECIAL_VAT_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968", InvoiceVerifyType.SPECIAL_VAT_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u589e\u503c\u7a0e\u4e13\u7968", InvoiceVerifyType.SPECIAL_VAT_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u589e\u4e13\u7968", InvoiceVerifyType.SPECIAL_VAT_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7eb8\u8d28\u4e13\u7528\u53d1\u7968", InvoiceVerifyType.SPECIAL_VAT_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7535\u5b50\u666e\u7968", InvoiceVerifyType.ELEC_NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7535\u5b50\u666e\u901a\u53d1\u7968", InvoiceVerifyType.ELEC_NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\uff08\u7535\u5b50\uff09", InvoiceVerifyType.ELEC_NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968(\u7535\u5b50)", InvoiceVerifyType.ELEC_NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968", InvoiceVerifyType.ELEC_NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7535\u5b50\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968", InvoiceVerifyType.ELEC_NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u901a\u7528\u673a\u6253\u7535\u5b50\u53d1\u7968", InvoiceVerifyType.ELEC_NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7535\u5b50\u4e13\u7968", InvoiceVerifyType.ELEC_SPECIAL_VAT_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7535\u5b50\u4e13\u7528\u53d1\u7968", InvoiceVerifyType.ELEC_SPECIAL_VAT_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968", InvoiceVerifyType.ELEC_SPECIAL_VAT_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff08\u7535\u5b50\uff09", InvoiceVerifyType.ELEC_SPECIAL_VAT_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968(\u7535\u5b50)", InvoiceVerifyType.ELEC_SPECIAL_VAT_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u5377\u5f0f\u53d1\u7968", InvoiceVerifyType.ROLL_NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u5377\u7968", InvoiceVerifyType.ROLL_NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\u5377\u5f0f", InvoiceVerifyType.ROLL_NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\uff08\u5377\u5f0f\uff09", InvoiceVerifyType.ROLL_NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968(\u5377\u5f0f)", InvoiceVerifyType.ROLL_NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\uff08\u5377\u7968\uff09", InvoiceVerifyType.ROLL_NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968(\u5377\u7968)", InvoiceVerifyType.ROLL_NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u901a\u884c\u8d39\u53d1\u7968", InvoiceVerifyType.TOLL_ELEC_NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u901a\u884c\u8d39\u7535\u5b50\u53d1\u7968", InvoiceVerifyType.TOLL_ELEC_NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u901a\u884c\u8d39\u7535\u5b50\u666e\u7968", InvoiceVerifyType.TOLL_ELEC_NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u901a\u884c\u8d39\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968", InvoiceVerifyType.TOLL_ELEC_NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968\uff08\u901a\u884c\u8d39\uff09", InvoiceVerifyType.TOLL_ELEC_NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968(\u901a\u884c\u8d39)", InvoiceVerifyType.TOLL_ELEC_NORMAL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u533a\u5757\u94fe\u53d1\u7968", InvoiceVerifyType.BLOCKCHAIN_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u533a\u5757\u94fe\u7535\u5b50\u53d1\u7968", InvoiceVerifyType.BLOCKCHAIN_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u533a\u5757\u94fe\u7535\u5b50\u666e\u901a\u53d1\u7968", InvoiceVerifyType.BLOCKCHAIN_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u6df1\u5733\u533a\u5757\u94fe\u7535\u5b50\u53d1\u7968", InvoiceVerifyType.BLOCKCHAIN_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u5168\u7535\u4e13\u7968", InvoiceVerifyType.ELEC_INVOICE_SPECIAL);
        OCR_TO_VERIFY_TYPE_MAP.put("\u5168\u7535\u53d1\u7968\u4e13\u7528\u53d1\u7968", InvoiceVerifyType.ELEC_INVOICE_SPECIAL);
        OCR_TO_VERIFY_TYPE_MAP.put("\u5168\u7535\u53d1\u7968(\u4e13\u7528\u53d1\u7968)", InvoiceVerifyType.ELEC_INVOICE_SPECIAL);
        OCR_TO_VERIFY_TYPE_MAP.put("\u5168\u7535\u53d1\u7968\uff08\u4e13\u7528\u53d1\u7968\uff09", InvoiceVerifyType.ELEC_INVOICE_SPECIAL);
        OCR_TO_VERIFY_TYPE_MAP.put("\u6570\u7535\u4e13\u7968", InvoiceVerifyType.ELEC_INVOICE_SPECIAL);
        OCR_TO_VERIFY_TYPE_MAP.put("\u6570\u5b57\u5316\u7535\u5b50\u53d1\u7968\uff08\u4e13\u7528\u53d1\u7968\uff09", InvoiceVerifyType.ELEC_INVOICE_SPECIAL);
        OCR_TO_VERIFY_TYPE_MAP.put("\u6570\u5b57\u5316\u7535\u5b50\u53d1\u7968(\u4e13\u7528\u53d1\u7968)", InvoiceVerifyType.ELEC_INVOICE_SPECIAL);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7535\u5b50\u53d1\u7968\uff08\u4e13\u7528\u53d1\u7968\uff09", InvoiceVerifyType.ELEC_INVOICE_SPECIAL);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7535\u5b50\u53d1\u7968(\u4e13\u7528\u53d1\u7968)", InvoiceVerifyType.ELEC_INVOICE_SPECIAL);
        OCR_TO_VERIFY_TYPE_MAP.put("\u5168\u7535\u666e\u7968", InvoiceVerifyType.ELEC_INVOICE_NORMAL);
        OCR_TO_VERIFY_TYPE_MAP.put("\u5168\u7535\u53d1\u7968\u666e\u901a\u53d1\u7968", InvoiceVerifyType.ELEC_INVOICE_NORMAL);
        OCR_TO_VERIFY_TYPE_MAP.put("\u5168\u7535\u53d1\u7968(\u666e\u901a\u53d1\u7968)", InvoiceVerifyType.ELEC_INVOICE_NORMAL);
        OCR_TO_VERIFY_TYPE_MAP.put("\u5168\u7535\u53d1\u7968\uff08\u666e\u901a\u53d1\u7968\uff09", InvoiceVerifyType.ELEC_INVOICE_NORMAL);
        OCR_TO_VERIFY_TYPE_MAP.put("\u6570\u7535\u666e\u7968", InvoiceVerifyType.ELEC_INVOICE_NORMAL);
        OCR_TO_VERIFY_TYPE_MAP.put("\u6570\u7535\u7968", InvoiceVerifyType.ELEC_INVOICE_NORMAL);
        OCR_TO_VERIFY_TYPE_MAP.put("\u6570\u5b57\u5316\u7535\u5b50\u53d1\u7968", InvoiceVerifyType.ELEC_INVOICE_NORMAL);
        OCR_TO_VERIFY_TYPE_MAP.put("\u6570\u5b57\u5316\u7535\u5b50\u53d1\u7968\uff08\u666e\u901a\u53d1\u7968\uff09", InvoiceVerifyType.ELEC_INVOICE_NORMAL);
        OCR_TO_VERIFY_TYPE_MAP.put("\u6570\u5b57\u5316\u7535\u5b50\u53d1\u7968(\u666e\u901a\u53d1\u7968)", InvoiceVerifyType.ELEC_INVOICE_NORMAL);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7535\u5b50\u53d1\u7968\uff08\u666e\u901a\u53d1\u7968\uff09", InvoiceVerifyType.ELEC_INVOICE_NORMAL);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7535\u5b50\u53d1\u7968(\u666e\u901a\u53d1\u7968)", InvoiceVerifyType.ELEC_INVOICE_NORMAL);
        OCR_TO_VERIFY_TYPE_MAP.put("\u8d27\u8fd0\u53d1\u7968", InvoiceVerifyType.SPECIAL_FREIGHT_TRANSPORT_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u8d27\u8fd0\u4e13\u7968", InvoiceVerifyType.SPECIAL_FREIGHT_TRANSPORT_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u8d27\u8fd0\u8fd0\u8f93\u4e1a\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968", InvoiceVerifyType.SPECIAL_FREIGHT_TRANSPORT_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u8d27\u7269\u8fd0\u8f93\u4e1a\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968", InvoiceVerifyType.SPECIAL_FREIGHT_TRANSPORT_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u673a\u52a8\u8f66\u53d1\u7968", InvoiceVerifyType.MOTOR_VEHICLE_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u673a\u52a8\u8f66\u9500\u552e\u53d1\u7968", InvoiceVerifyType.MOTOR_VEHICLE_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968", InvoiceVerifyType.MOTOR_VEHICLE_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\uff08\u7535\u5b50\uff09", InvoiceVerifyType.MOTOR_VEHICLE_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968(\u7535\u5b50)", InvoiceVerifyType.MOTOR_VEHICLE_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7535\u5b50\u53d1\u7968\uff08\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\uff09", InvoiceVerifyType.MOTOR_VEHICLE_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7535\u5b50\u53d1\u7968(\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968)", InvoiceVerifyType.MOTOR_VEHICLE_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7eb8\u8d28\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968", InvoiceVerifyType.MOTOR_VEHICLE_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7535\u5b50\u53d1\u7968\uff08\u7eb8\u8d28\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\uff09", InvoiceVerifyType.MOTOR_VEHICLE_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7535\u5b50\u53d1\u7968(\u7eb8\u8d28\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968)", InvoiceVerifyType.MOTOR_VEHICLE_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u65b0\u8f66\u53d1\u7968", InvoiceVerifyType.MOTOR_VEHICLE_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u4e8c\u624b\u8f66\u53d1\u7968", InvoiceVerifyType.USED_VEHICLE_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u4e8c\u624b\u8f66\u9500\u552e\u53d1\u7968", InvoiceVerifyType.USED_VEHICLE_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u4e8c\u624b\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968", InvoiceVerifyType.USED_VEHICLE_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u4e8c\u624b\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\uff08\u7535\u5b50\uff09", InvoiceVerifyType.USED_VEHICLE_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u4e8c\u624b\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968(\u7535\u5b50)", InvoiceVerifyType.USED_VEHICLE_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7535\u5b50\u53d1\u7968\uff08\u4e8c\u624b\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\uff09", InvoiceVerifyType.USED_VEHICLE_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7535\u5b50\u53d1\u7968(\u4e8c\u624b\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968)", InvoiceVerifyType.USED_VEHICLE_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7eb8\u8d28\u4e8c\u624b\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968", InvoiceVerifyType.USED_VEHICLE_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7535\u5b50\u53d1\u7968\uff08\u7eb8\u8d28\u4e8c\u624b\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\uff09", InvoiceVerifyType.USED_VEHICLE_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7535\u5b50\u53d1\u7968(\u7eb8\u8d28\u4e8c\u624b\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968)", InvoiceVerifyType.USED_VEHICLE_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u822a\u7a7a\u5ba2\u7968", InvoiceVerifyType.ELEC_FLIGHT_ITINERARY_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u822a\u7a7a\u7535\u5b50\u5ba2\u7968", InvoiceVerifyType.ELEC_FLIGHT_ITINERARY_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u822a\u7a7a\u8fd0\u8f93\u7535\u5b50\u5ba2\u7968\u884c\u7a0b\u5355", InvoiceVerifyType.ELEC_FLIGHT_ITINERARY_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7535\u5b50\u53d1\u7968\uff08\u822a\u7a7a\u8fd0\u8f93\u7535\u5b50\u5ba2\u7968\u884c\u7a0b\u5355\uff09", InvoiceVerifyType.ELEC_FLIGHT_ITINERARY_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7535\u5b50\u53d1\u7968(\u822a\u7a7a\u8fd0\u8f93\u7535\u5b50\u5ba2\u7968\u884c\u7a0b\u5355)", InvoiceVerifyType.ELEC_FLIGHT_ITINERARY_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u98de\u673a\u7968", InvoiceVerifyType.ELEC_FLIGHT_ITINERARY_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u673a\u7968\u884c\u7a0b\u5355", InvoiceVerifyType.ELEC_FLIGHT_ITINERARY_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u94c1\u8def\u5ba2\u7968", InvoiceVerifyType.ELEC_TRAIN_TICKET_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u94c1\u8def\u7535\u5b50\u5ba2\u7968", InvoiceVerifyType.ELEC_TRAIN_TICKET_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7535\u5b50\u53d1\u7968\uff08\u94c1\u8def\u7535\u5b50\u5ba2\u7968\uff09", InvoiceVerifyType.ELEC_TRAIN_TICKET_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u7535\u5b50\u53d1\u7968(\u94c1\u8def\u7535\u5b50\u5ba2\u7968)", InvoiceVerifyType.ELEC_TRAIN_TICKET_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u706b\u8f66\u7968", InvoiceVerifyType.ELEC_TRAIN_TICKET_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u9ad8\u94c1\u7968", InvoiceVerifyType.ELEC_TRAIN_TICKET_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u5168\u7535\u901a\u884c\u8d39\u53d1\u7968", InvoiceVerifyType.ELEC_TOLL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u5168\u7535\u53d1\u7968\u542b\u901a\u884c\u8d39\u6807\u8bc6", InvoiceVerifyType.ELEC_TOLL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u5168\u7535\u53d1\u7968\uff08\u542b\u901a\u884c\u8d39\u6807\u8bc6\uff09", InvoiceVerifyType.ELEC_TOLL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u5168\u7535\u53d1\u7968(\u542b\u901a\u884c\u8d39\u6807\u8bc6)", InvoiceVerifyType.ELEC_TOLL_INVOICE);
        OCR_TO_VERIFY_TYPE_MAP.put("\u6570\u7535\u53d1\u7968\uff08\u901a\u884c\u8d39\uff09", InvoiceVerifyType.ELEC_TOLL_INVOICE);
    }
}

