/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.spring.boot.bdocr.model;

import cn.hutool.v7.core.date.DateUtil;
import cn.hutool.v7.core.date.TimeUtil;
import cn.hutool.v7.core.text.StrUtil;
import cn.toint.oktool.spring.boot.bdocr.model.InvoiceVerifyType;
import cn.toint.oktool.spring.boot.bdocr.util.InvoiceTypeConverter;
import cn.toint.oktool.spring.boot.bdocr.util.InvoiceVerifyAmountUtil;
import cn.toint.oktool.util.AmountUtil;
import cn.toint.oktool.util.Assert;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class VatInvoiceVerificationRequest {
    @JsonProperty(value="invoice_code")
    private String invoiceCode;
    @JsonProperty(value="invoice_num")
    private String invoiceNum;
    @JsonProperty(value="invoice_date")
    private String invoiceDate;
    @JsonProperty(value="invoice_type")
    private String invoiceType;
    @JsonProperty(value="check_code")
    private String checkCode;
    @JsonProperty(value="total_amount")
    private String totalAmount;

    public VatInvoiceVerificationRequest invoiceDate(TemporalAccessor invoiceDate) {
        Assert.notNull((Object)invoiceDate, (CharSequence)"invoiceDate must not be null", (Object[])new Object[0]);
        this.invoiceDate = TimeUtil.format((TemporalAccessor)invoiceDate, (String)"yyyyMMdd");
        return this;
    }

    public VatInvoiceVerificationRequest invoiceDate(Date invoiceDate) {
        Assert.notNull((Object)invoiceDate, (CharSequence)"invoiceDate must not be null", (Object[])new Object[0]);
        this.invoiceDate = DateUtil.format((Date)invoiceDate, (String)"yyyyMMdd");
        return this;
    }

    public VatInvoiceVerificationRequest invoiceDate(String invoiceDateStr) {
        Assert.notBlank((CharSequence)invoiceDateStr, (CharSequence)"invoiceDate must not be blank", (Object[])new Object[0]);
        this.invoiceDate = DateUtil.parse((CharSequence)invoiceDateStr).toString("yyyyMMdd");
        return this;
    }

    public VatInvoiceVerificationRequest invoiceType(InvoiceVerifyType invoiceVerifyType) {
        Assert.notNull((Object)((Object)invoiceVerifyType), (CharSequence)"invoiceVerifyType must not be null", (Object[])new Object[0]);
        this.invoiceType = invoiceVerifyType.getCode();
        return this;
    }

    public VatInvoiceVerificationRequest invoiceType(String invoiceVerifyTypeStr) {
        Assert.notBlank((CharSequence)invoiceVerifyTypeStr, (CharSequence)"invoiceVerifyType must not be blank", (Object[])new Object[0]);
        InvoiceVerifyType invoiceVerifyType = InvoiceTypeConverter.convertOcrToVerifyType(invoiceVerifyTypeStr);
        Assert.notNull((Object)((Object)invoiceVerifyType), (CharSequence)"\u53d1\u7968\u7c7b\u578b\u89e3\u6790\u5931\u8d25", (Object[])new Object[0]);
        this.invoiceType = invoiceVerifyType.getCode();
        return this;
    }

    public VatInvoiceVerificationRequest totalAmount(String totalAmount) {
        if (StringUtils.isNotBlank((CharSequence)totalAmount)) {
            BigDecimal bigDecimal = AmountUtil.toBigDecimal((String)totalAmount);
            Assert.notNull((Object)bigDecimal, (CharSequence)"\u91d1\u989d\u8f6c\u6362\u5931\u8d25", (Object[])new Object[0]);
            this.totalAmount = bigDecimal.toPlainString();
        }
        return this;
    }

    public VatInvoiceVerificationRequest totalAmount(String invoiceType, String totalAmount, String totalAmountInclTax) {
        String amount = InvoiceVerifyAmountUtil.getAmountByInvoiceType(invoiceType, totalAmount, totalAmountInclTax);
        if (amount != null) {
            return this.totalAmount(amount);
        }
        return this;
    }

    public VatInvoiceVerificationRequest checkCode(String checkCode) {
        if (StringUtils.isNotBlank((CharSequence)checkCode)) {
            String subCheckCode = StrUtil.subSufByLength((CharSequence)checkCode, (int)6);
            Assert.isTrue((subCheckCode.length() == 6 ? 1 : 0) != 0, (CharSequence)"\u6821\u9a8c\u7801\u957f\u5ea6\u5fc5\u987b\u4e3a6\u4f4d", (Object[])new Object[0]);
            this.checkCode = subCheckCode;
        }
        return this;
    }

    public String getInvoiceCode() {
        return this.invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    public String getInvoiceNum() {
        return this.invoiceNum;
    }

    public void setInvoiceNum(String invoiceNum) {
        this.invoiceNum = invoiceNum;
    }

    public String getInvoiceDate() {
        return this.invoiceDate;
    }

    public void setInvoiceDate(String invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public String getInvoiceType() {
        return this.invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getCheckCode() {
        return this.checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }

    public String getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VatInvoiceVerificationRequest that = (VatInvoiceVerificationRequest)o;
        return Objects.equals(this.invoiceCode, that.invoiceCode) && Objects.equals(this.invoiceNum, that.invoiceNum) && Objects.equals(this.invoiceDate, that.invoiceDate) && Objects.equals(this.invoiceType, that.invoiceType) && Objects.equals(this.checkCode, that.checkCode) && Objects.equals(this.totalAmount, that.totalAmount);
    }

    public int hashCode() {
        return Objects.hash(this.invoiceCode, this.invoiceNum, this.invoiceDate, this.invoiceType, this.checkCode, this.totalAmount);
    }

    public String toString() {
        return "VatInvoiceVerificationRequest{invoiceCode='" + this.invoiceCode + "', invoiceNum='" + this.invoiceNum + "', invoiceDate='" + this.invoiceDate + "', invoiceType='" + this.invoiceType + "', checkCode='" + this.checkCode + "', totalAmount='" + this.totalAmount + "'}";
    }
}

