/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.spring.boot.bdocr.model;

import cn.hutool.v7.core.codec.binary.Base64;
import cn.hutool.v7.core.io.IoUtil;
import cn.hutool.v7.core.io.file.FileTypeUtil;
import cn.hutool.v7.core.net.url.UrlEncoder;
import cn.hutool.v7.http.HttpUtil;
import cn.hutool.v7.http.client.Request;
import cn.hutool.v7.http.client.Response;
import cn.hutool.v7.http.meta.HeaderName;
import cn.hutool.v7.http.meta.HttpHeaderUtil;
import cn.hutool.v7.http.meta.HttpStatus;
import cn.toint.oktool.util.Assert;
import cn.toint.oktool.util.FileNameUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;

public class BaseOcrRequest {
    private String image;
    private String url;
    @JsonProperty(value="pdf_file")
    private String pdfFile;
    @JsonProperty(value="pdf_file_num")
    private int pdfFileNum = 1;
    @JsonProperty(value="ofd_file")
    private String ofdFile;
    @JsonProperty(value="ofd_file_num")
    private int ofdFileNum = 1;

    public BaseOcrRequest() {
    }

    public BaseOcrRequest(String url) {
        this.file(url);
    }

    public BaseOcrRequest(byte[] bytes) {
        this.file(bytes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseOcrRequest file(String fileUrl) {
        Assert.notBlank((CharSequence)fileUrl, (CharSequence)"fileUrl must not be blank", (Object[])new Object[0]);
        AtomicInteger maxRedirectSize = new AtomicInteger(5);
        Request request = HttpUtil.createGet((String)fileUrl);
        request.header(HeaderName.USER_AGENT, null);
        try (Response response = request.send();){
            int code = response.getStatus();
            if (HttpStatus.isRedirected((int)code)) {
                Assert.isTrue((maxRedirectSize.decrementAndGet() >= 0 ? 1 : 0) != 0, (CharSequence)"\u6587\u4ef6\u4e0b\u8f7d\u8fbe\u5230\u6700\u5927\u91cd\u5b9a\u5411\u6b21\u6570, \u5df2\u62e6\u622a", (Object[])new Object[0]);
                BaseOcrRequest baseOcrRequest2 = this.file(response.header(HeaderName.LOCATION.getValue()));
                return baseOcrRequest2;
            }
            long contentLength = response.contentLength();
            this.checkFileSize(contentLength);
            String extName = null;
            String fileName = HttpHeaderUtil.getFileNameFromDisposition((Map)response.headers(), null);
            if (StringUtils.isNotBlank((CharSequence)fileName)) {
                extName = FileNameUtil.getSuffix((String)fileName);
            }
            byte[] fileBytes = response.bodyBytes();
            BaseOcrRequest baseOcrRequest = this.file(fileBytes, extName);
            return baseOcrRequest;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public BaseOcrRequest file(byte[] fileBytes) {
        this.file(fileBytes, null);
        return this;
    }

    public BaseOcrRequest file(byte[] fileBytes, String extName) {
        Assert.notNull((Object)fileBytes, (CharSequence)"fileBytes must not be null", (Object[])new Object[0]);
        this.checkFileSize(fileBytes.length);
        if (StringUtils.isBlank((CharSequence)extName)) {
            try (ByteArrayInputStream byteArrayInputStream = IoUtil.toStream((byte[])fileBytes);){
                extName = FileTypeUtil.getType((InputStream)byteArrayInputStream);
                Assert.notBlank((CharSequence)extName, (CharSequence)"\u65e0\u6cd5\u8bfb\u53d6\u6587\u4ef6\u683c\u5f0f", (Object[])new Object[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if ("pdf".equalsIgnoreCase(extName)) {
            this.setPdfFile(this.urlEncodeAndBase64(fileBytes));
        } else if ("ofd".contains(extName)) {
            this.setOfdFile(this.urlEncodeAndBase64(fileBytes));
        } else if (List.of("jpg", "jpeg", "png", "bmp").contains(extName)) {
            this.setImage(this.urlEncodeAndBase64(fileBytes));
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u683c\u5f0f: " + extName);
        }
        return this;
    }

    private void checkFileSize(long fileSize) {
        if (fileSize <= 0L) {
            throw new RuntimeException("\u65e0\u6548\u7684\u6587\u4ef6");
        }
        if (fileSize > 0x400000L) {
            throw new RuntimeException("\u6587\u4ef6\u8fc7\u5927");
        }
    }

    private String urlEncodeAndBase64(byte[] fileBytes) {
        return UrlEncoder.encodeQuery((String)Base64.encode((byte[])fileBytes));
    }

    private static String urlEncodeAndBase64(File file) {
        return UrlEncoder.encodeQuery((String)Base64.encode((File)file));
    }

    public void checkFile() {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.getUrl(), this.getImage(), this.getPdfFile(), this.getOfdFile()})) {
            throw new RuntimeException("image/url/pdf_file/ofd_file, 4\u90091");
        }
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPdfFile() {
        return this.pdfFile;
    }

    public void setPdfFile(String pdfFile) {
        this.pdfFile = pdfFile;
    }

    public int getPdfFileNum() {
        return this.pdfFileNum;
    }

    public void setPdfFileNum(int pdfFileNum) {
        this.pdfFileNum = pdfFileNum;
    }

    public String getOfdFile() {
        return this.ofdFile;
    }

    public void setOfdFile(String ofdFile) {
        this.ofdFile = ofdFile;
    }

    public int getOfdFileNum() {
        return this.ofdFileNum;
    }

    public void setOfdFileNum(int ofdFileNum) {
        this.ofdFileNum = ofdFileNum;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseOcrRequest that = (BaseOcrRequest)o;
        return this.pdfFileNum == that.pdfFileNum && this.ofdFileNum == that.ofdFileNum && Objects.equals(this.image, that.image) && Objects.equals(this.url, that.url) && Objects.equals(this.pdfFile, that.pdfFile) && Objects.equals(this.ofdFile, that.ofdFile);
    }

    public int hashCode() {
        return Objects.hash(this.image, this.url, this.pdfFile, this.pdfFileNum, this.ofdFile, this.ofdFileNum);
    }

    public String toString() {
        return "BaseOcrRequest{image='" + this.image + "', url='" + this.url + "', pdfFile='" + this.pdfFile + "', pdfFileNum=" + this.pdfFileNum + ", ofdFile='" + this.ofdFile + "', ofdFileNum=" + this.ofdFileNum + "}";
    }
}

