/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.spring.boot.config;

import cn.toint.oktool.spring.boot.properties.JacksonProperties;
import cn.toint.oktool.util.JacksonUtil;
import com.fasterxml.jackson.databind.Module;
import jakarta.annotation.Resource;
import java.time.ZoneId;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JacksonModelConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JacksonModelConfig.class);
    @Resource
    private JacksonProperties jacksonProperties;

    @Bean
    @ConditionalOnProperty(name={"oktool.jackson.local-date-time-module.enabled"}, havingValue="true", matchIfMissing=true)
    public Module jacksonLocalDateTimeModule() {
        JacksonProperties.LocalDateTimeModule localDateTimeModule = this.jacksonProperties.getLocalDateTimeModule();
        ZoneId zoneId = ZoneId.of(localDateTimeModule.getZoneId());
        String pattern = localDateTimeModule.getPattern();
        Module timeModule = JacksonUtil.createLocalDateTimeModule((String)pattern, (ZoneId)zoneId);
        log.info("Jackson LocalDateTimeModule\u521d\u59cb\u5316\u6210\u529f. \u53cd\u5e8f\u5217\u5316\u914d\u7f6e: \u52a8\u6001\u8bc6\u522b\u683c\u5f0f. \u5e8f\u5217\u5316\u914d\u7f6e: zoneId={}, pattern={}", (Object)zoneId, (Object)pattern);
        return timeModule;
    }

    @Bean
    @ConditionalOnProperty(name={"oktool.jackson.safe-long-module.enabled"}, havingValue="true", matchIfMissing=true)
    public Module jacksonSafeLongModule() {
        Module longModule = JacksonUtil.createSafeLongModule();
        log.info("Jackson SafeLongModule\u521d\u59cb\u5316\u6210\u529f");
        return longModule;
    }
}

