/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.spring.boot.cache.impl;

import cn.toint.oktool.spring.boot.cache.Cache;
import cn.toint.oktool.util.Assert;
import jakarta.annotation.Resource;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisCacheImpl
implements Cache {
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public void put(String key, String value, Duration timeout) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)timeout, (CharSequence)"\u7f13\u5b58\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, timeout);
    }

    @Override
    public boolean putIfAbsent(String key, String value, Duration timeout) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)timeout, (CharSequence)"\u7f13\u5b58\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Boolean status = this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, timeout);
        return Objects.equals(Boolean.TRUE, status);
    }

    @Override
    public String get(String key) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return (String)this.stringRedisTemplate.opsForValue().get((Object)key);
    }

    @Override
    public List<String> multiGet(Collection<String> keys) {
        Assert.notEmpty(keys, (CharSequence)"keys\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.stringRedisTemplate.opsForValue().multiGet(keys);
    }

    @Override
    public boolean containsKey(String key) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Boolean hasKey = this.stringRedisTemplate.hasKey((Object)key);
        return Objects.equals(Boolean.TRUE, hasKey);
    }

    @Override
    public void delete(String key) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.stringRedisTemplate.delete((Object)key);
    }
}

