/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.spring.boot.cache.impl;

import cn.hutool.v7.core.cache.impl.TimedCache;
import cn.toint.oktool.spring.boot.cache.Cache;
import cn.toint.oktool.util.Assert;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class LocalCacheImpl
implements Cache {
    private final TimedCache<String, String> timedCache = this.initTimedCache();
    private final ReentrantLock putIfAbsentLock = new ReentrantLock();

    @Override
    public void put(String key, String value, Duration timeout) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)timeout, (CharSequence)"\u7f13\u5b58\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.timedCache.put((Object)key, (Object)value, timeout.toMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putIfAbsent(String key, String value, Duration timeout) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)timeout, (CharSequence)"\u7f13\u5b58\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.putIfAbsentLock.lock();
        try {
            if (this.timedCache.containsKey((Object)key)) {
                boolean bl = false;
                return bl;
            }
            this.timedCache.put((Object)key, (Object)value, timeout.toMillis());
            boolean bl = true;
            return bl;
        }
        finally {
            this.putIfAbsentLock.unlock();
        }
    }

    @Override
    public String get(String key) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return (String)this.timedCache.get((Object)key);
    }

    @Override
    public List<String> multiGet(Collection<String> keys) {
        Assert.notEmpty(keys, (CharSequence)"keys\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList<String> values = new ArrayList<String>();
        for (String key : keys) {
            values.add(this.get(key));
        }
        return values;
    }

    @Override
    public boolean containsKey(String key) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.timedCache.containsKey((Object)key);
    }

    @Override
    public void delete(String key) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.timedCache.remove((Object)key);
    }

    private TimedCache<String, String> initTimedCache() {
        TimedCache timedCache = new TimedCache(0L);
        timedCache.schedulePrune(60000L);
        return timedCache;
    }
}

