/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.spring.boot.bdocr.util;

import cn.hutool.v7.core.collection.CollUtil;
import cn.toint.oktool.spring.boot.bdocr.model.MultipleInvoiceResponse;
import cn.toint.oktool.spring.boot.bdocr.model.MultipleInvoiceVo;
import cn.toint.oktool.spring.boot.bdocr.model.TicketTypeEnum;
import cn.toint.oktool.spring.boot.bdocr.model.Word;
import cn.toint.oktool.spring.boot.bdocr.util.WordUtil;
import cn.toint.oktool.util.Assert;
import cn.toint.oktool.util.JacksonUtil;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class MultipleInvoiceUtil {
    public static MultipleInvoiceVo convert(MultipleInvoiceResponse multipleInvoiceResponse) {
        Assert.notNull((Object)multipleInvoiceResponse, (CharSequence)"multipleInvoiceResponse must not be null", (Object[])new Object[0]);
        MultipleInvoiceVo multipleInvoiceVo = new MultipleInvoiceVo();
        multipleInvoiceVo.setLogId(multipleInvoiceResponse.getLogId());
        Integer wordsResultNum = multipleInvoiceResponse.getWordsResultNum();
        multipleInvoiceVo.setWordsResultNum(wordsResultNum);
        if (wordsResultNum == null || wordsResultNum < 1) {
            return multipleInvoiceVo;
        }
        List<MultipleInvoiceResponse.WordsResult> wordsResult = multipleInvoiceResponse.getWordsResult();
        if (CollUtil.isEmpty(wordsResult)) {
            return multipleInvoiceVo;
        }
        wordsResult.forEach(item -> {
            TicketTypeEnum ticketTypeEnum = item.typeEnum();
            if (ticketTypeEnum == null) {
                return;
            }
            JsonNode result = item.getResult();
            if (JacksonUtil.isNull((JsonNode)result)) {
                return;
            }
            if (TicketTypeEnum.VAT_INVOICE.equals((Object)ticketTypeEnum)) {
                MultipleInvoiceVo.VatInvoice vatInvoice = MultipleInvoiceUtil.convertVatInvoice((MultipleInvoiceResponse.VatInvoiceResult)JacksonUtil.convertValue((Object)result, MultipleInvoiceResponse.VatInvoiceResult.class));
                multipleInvoiceVo.getVatInvoice().add(vatInvoice);
                return;
            }
            if (TicketTypeEnum.TRAIN_TICKET.equals((Object)ticketTypeEnum)) {
                MultipleInvoiceVo.TrainTicket trainTicket = MultipleInvoiceUtil.convertVatTrainTicket((MultipleInvoiceResponse.TrainTicketResult)JacksonUtil.convertValue((Object)result, MultipleInvoiceResponse.TrainTicketResult.class));
                multipleInvoiceVo.getTrainTicket().add(trainTicket);
                return;
            }
            if (TicketTypeEnum.TAXI_ONLINE_TICKET.equals((Object)ticketTypeEnum)) {
                MultipleInvoiceVo.TaxiOnlineTicket taxiOnlineTicket = MultipleInvoiceUtil.convertTaxiOnlineTicket((MultipleInvoiceResponse.TaxiOnlineTicketResult)JacksonUtil.convertValue((Object)result, MultipleInvoiceResponse.TaxiOnlineTicketResult.class));
                multipleInvoiceVo.getTaxiOnlineTicket().add(taxiOnlineTicket);
                return;
            }
            if (TicketTypeEnum.AIR_TICKET.equals((Object)ticketTypeEnum)) {
                MultipleInvoiceVo.AirTicket airTicket = MultipleInvoiceUtil.convertAirTicket((MultipleInvoiceResponse.AirTicketResult)JacksonUtil.convertValue((Object)result, MultipleInvoiceResponse.AirTicketResult.class));
                multipleInvoiceVo.getAirTicket().add(airTicket);
                return;
            }
            if (TicketTypeEnum.TAXI_RECEIPT.equals((Object)ticketTypeEnum)) {
                multipleInvoiceVo.getTaxiReceipt().add(result);
                return;
            }
            if (TicketTypeEnum.QUOTA_INVOICE.equals((Object)ticketTypeEnum)) {
                multipleInvoiceVo.getQuotaInvoice().add(result);
                return;
            }
            if (TicketTypeEnum.ROLL_NORMAL_INVOICE.equals((Object)ticketTypeEnum)) {
                multipleInvoiceVo.getRollNormalInvoice().add(result);
                return;
            }
            if (TicketTypeEnum.PRINTED_INVOICE.equals((Object)ticketTypeEnum)) {
                multipleInvoiceVo.getPrintedInvoice().add(result);
                return;
            }
            if (TicketTypeEnum.PRINTED_ELEC_INVOICE.equals((Object)ticketTypeEnum)) {
                multipleInvoiceVo.getPrintedElecInvoice().add(result);
                return;
            }
            if (TicketTypeEnum.BUS_TICKET.equals((Object)ticketTypeEnum)) {
                multipleInvoiceVo.getBusTicket().add(result);
                return;
            }
            if (TicketTypeEnum.TOLL_INVOICE.equals((Object)ticketTypeEnum)) {
                multipleInvoiceVo.getTollInvoice().add(result);
                return;
            }
            if (TicketTypeEnum.FERRY_TICKET.equals((Object)ticketTypeEnum)) {
                multipleInvoiceVo.getFerryTicket().add(result);
                return;
            }
            if (TicketTypeEnum.MOTOR_VEHICLE_INVOICE.equals((Object)ticketTypeEnum)) {
                multipleInvoiceVo.getMotorVehicleInvoice().add(result);
                return;
            }
            if (TicketTypeEnum.USED_VEHICLE_INVOICE.equals((Object)ticketTypeEnum)) {
                multipleInvoiceVo.getUsedVehicleInvoice().add(result);
                return;
            }
            if (TicketTypeEnum.LIMIT_INVOICE.equals((Object)ticketTypeEnum)) {
                multipleInvoiceVo.getLimitInvoice().add(result);
                return;
            }
            if (TicketTypeEnum.SHOPPING_RECEIPT.equals((Object)ticketTypeEnum)) {
                multipleInvoiceVo.getShoppingReceipt().add(result);
                return;
            }
            if (TicketTypeEnum.POS_INVOICE.equals((Object)ticketTypeEnum)) {
                multipleInvoiceVo.getPosInvoice().add(result);
                return;
            }
            if (TicketTypeEnum.OTHERS.equals((Object)ticketTypeEnum)) {
                multipleInvoiceVo.getOthers().add(result);
                return;
            }
        });
        return multipleInvoiceVo;
    }

    public static MultipleInvoiceVo.AirTicket convertAirTicket(MultipleInvoiceResponse.AirTicketResult airTicketResult) {
        Assert.notNull((Object)airTicketResult, (CharSequence)"airTicketResult must not be null", (Object[])new Object[0]);
        MultipleInvoiceVo.AirTicket airTicket = new MultipleInvoiceVo.AirTicket();
        airTicket.setServiceType(WordUtil.getFirstWord(airTicketResult.getServiceType()));
        airTicket.setName(WordUtil.getFirstWord(airTicketResult.getName()));
        airTicket.setStartingStation(WordUtil.getFirstWord(airTicketResult.getStartingStation()));
        airTicket.setDestinationStation(WordUtil.getFirstWord(airTicketResult.getDestinationStation()));
        airTicket.setFlight(WordUtil.getFirstWord(airTicketResult.getFlight()));
        airTicket.setDate(WordUtil.getFirstWord(airTicketResult.getDate()));
        airTicket.setTicketNumber(WordUtil.getFirstWord(airTicketResult.getTicketNumber()));
        airTicket.setFare(WordUtil.getFirstWord(airTicketResult.getFare()));
        airTicket.setDevFund(WordUtil.getFirstWord(airTicketResult.getDevFund()));
        airTicket.setOilMoney(WordUtil.getFirstWord(airTicketResult.getOilMoney()));
        airTicket.setOtherTax(WordUtil.getFirstWord(airTicketResult.getOtherTax()));
        airTicket.setTicketRates(WordUtil.getFirstWord(airTicketResult.getTicketRates()));
        airTicket.setStartDate(WordUtil.getFirstWord(airTicketResult.getStartDate()));
        airTicket.setIdNo(WordUtil.getFirstWord(airTicketResult.getIdNo()));
        airTicket.setCarrier(WordUtil.getFirstWord(airTicketResult.getCarrier()));
        airTicket.setTime(WordUtil.getFirstWord(airTicketResult.getTime()));
        airTicket.setIssuedBy(WordUtil.getFirstWord(airTicketResult.getIssuedBy()));
        airTicket.setSerialNumber(WordUtil.getFirstWord(airTicketResult.getSerialNumber()));
        airTicket.setInsurance(WordUtil.getFirstWord(airTicketResult.getInsurance()));
        airTicket.setFareBasis(WordUtil.getFirstWord(airTicketResult.getFareBasis()));
        airTicket.setClazz(WordUtil.getFirstWord(airTicketResult.getClazz()));
        airTicket.setAgentCode(WordUtil.getFirstWord(airTicketResult.getAgentCode()));
        airTicket.setEndorsement(WordUtil.getFirstWord(airTicketResult.getEndorsement()));
        airTicket.setAllow(WordUtil.getFirstWord(airTicketResult.getAllow()));
        airTicket.setCk(WordUtil.getFirstWord(airTicketResult.getCk()));
        airTicket.setEffectiveDate(WordUtil.getFirstWord(airTicketResult.getEffectiveDate()));
        airTicket.setExpirationDate(WordUtil.getFirstWord(airTicketResult.getExpirationDate()));
        airTicket.setInvoiceTypeOrg(WordUtil.getFirstWord(airTicketResult.getInvoiceTypeOrg()));
        airTicket.setIdentification(WordUtil.getFirstWord(airTicketResult.getIdentification()));
        airTicket.setInvoiceStatus(WordUtil.getFirstWord(airTicketResult.getInvoiceStatus()));
        airTicket.setInvoiceNum(WordUtil.getFirstWord(airTicketResult.getInvoiceNum()));
        airTicket.setCommodityTaxRate(WordUtil.getFirstWord(airTicketResult.getCommodityTaxRate()));
        airTicket.setCommodityTax(WordUtil.getFirstWord(airTicketResult.getCommodityTax()));
        airTicket.setPurchaserName(WordUtil.getFirstWord(airTicketResult.getPurchaserName()));
        airTicket.setPurchaserRegisterNum(WordUtil.getFirstWord(airTicketResult.getPurchaserRegisterNum()));
        return airTicket;
    }

    public static MultipleInvoiceVo.TaxiOnlineTicket convertTaxiOnlineTicket(MultipleInvoiceResponse.TaxiOnlineTicketResult taxiOnlineTicketResult) {
        Assert.notNull((Object)taxiOnlineTicketResult, (CharSequence)"taxiOnlineTicketResult must not be null", (Object[])new Object[0]);
        MultipleInvoiceVo.TaxiOnlineTicket taxiOnlineTicket = new MultipleInvoiceVo.TaxiOnlineTicket();
        taxiOnlineTicket.setServiceType(WordUtil.getFirstWord(taxiOnlineTicketResult.getServiceType()));
        taxiOnlineTicket.setServiceProvider(WordUtil.getFirstWord(taxiOnlineTicketResult.getServiceProvider()));
        taxiOnlineTicket.setStartTime(WordUtil.getFirstWord(taxiOnlineTicketResult.getStartTime()));
        taxiOnlineTicket.setDestinationTime(WordUtil.getFirstWord(taxiOnlineTicketResult.getDestinationTime()));
        taxiOnlineTicket.setPhone(WordUtil.getFirstWord(taxiOnlineTicketResult.getPhone()));
        taxiOnlineTicket.setApplicationDate(WordUtil.getFirstWord(taxiOnlineTicketResult.getApplicationDate()));
        taxiOnlineTicket.setTotalFare(WordUtil.getFirstWord(taxiOnlineTicketResult.getTotalFare()));
        taxiOnlineTicket.setItemNum(WordUtil.getFirstWord(taxiOnlineTicketResult.getItemNum()));
        if (CollUtil.isNotEmpty(taxiOnlineTicketResult.getDetails())) {
            List<MultipleInvoiceVo.TaxiOnlineTicket.Detail> details = taxiOnlineTicketResult.getDetails().stream().map(item -> {
                MultipleInvoiceVo.TaxiOnlineTicket.Detail detail = new MultipleInvoiceVo.TaxiOnlineTicket.Detail();
                detail.setItemId(WordUtil.getWord(item.getItemId()));
                detail.setItemProvider(WordUtil.getWord(item.getItemProvider()));
                detail.setPickupTime(WordUtil.getWord(item.getPickupTime()));
                detail.setPickupDate(WordUtil.getWord(item.getPickupDate()));
                detail.setCarType(WordUtil.getWord(item.getCarType()));
                detail.setDistance(WordUtil.getWord(item.getDistance()));
                detail.setStartPlace(WordUtil.getWord(item.getStartPlace()));
                detail.setDestinationPlace(WordUtil.getWord(item.getDestinationPlace()));
                detail.setCity(WordUtil.getWord(item.getCity()));
                detail.setFare(WordUtil.getWord(item.getFare()));
                return detail;
            }).collect(Collectors.toList());
            taxiOnlineTicket.setDetails(details);
        }
        return taxiOnlineTicket;
    }

    public static MultipleInvoiceVo.TrainTicket convertVatTrainTicket(MultipleInvoiceResponse.TrainTicketResult trainTicketResult) {
        Assert.notNull((Object)trainTicketResult, (CharSequence)"trainTicketResult must not be null", (Object[])new Object[0]);
        MultipleInvoiceVo.TrainTicket trainTicket = new MultipleInvoiceVo.TrainTicket();
        trainTicket.setServiceType(WordUtil.getFirstWord(trainTicketResult.getServiceType()));
        trainTicket.setTicketNum(WordUtil.getFirstWord(trainTicketResult.getTicketNum()));
        trainTicket.setStartingStation(WordUtil.getFirstWord(trainTicketResult.getStartingStation()));
        trainTicket.setTrainNum(WordUtil.getFirstWord(trainTicketResult.getTrainNum()));
        trainTicket.setDestinationStation(WordUtil.getFirstWord(trainTicketResult.getDestinationStation()));
        trainTicket.setDate(WordUtil.getFirstWord(trainTicketResult.getDate()));
        trainTicket.setTicketRates(WordUtil.getFirstWord(trainTicketResult.getTicketRates()));
        trainTicket.setSeatCategory(WordUtil.getFirstWord(trainTicketResult.getSeatCategory()));
        trainTicket.setName(WordUtil.getFirstWord(trainTicketResult.getName()));
        trainTicket.setIdCard(WordUtil.getFirstWord(trainTicketResult.getIdCard()));
        trainTicket.setSerialNumber(WordUtil.getFirstWord(trainTicketResult.getSerialNumber()));
        trainTicket.setSalesStation(WordUtil.getFirstWord(trainTicketResult.getSalesStation()));
        trainTicket.setTime(WordUtil.getFirstWord(trainTicketResult.getTime()));
        trainTicket.setSeatNum(WordUtil.getFirstWord(trainTicketResult.getSeatNum()));
        trainTicket.setWaitingArea(WordUtil.getFirstWord(trainTicketResult.getWaitingArea()));
        trainTicket.setRefundFlag(WordUtil.getFirstWord(trainTicketResult.getRefundFlag()));
        trainTicket.setInvoiceNum(WordUtil.getFirstWord(trainTicketResult.getInvoiceNum()));
        trainTicket.setInvoiceDate(WordUtil.getFirstWord(trainTicketResult.getInvoiceDate()));
        trainTicket.setFare(WordUtil.getFirstWord(trainTicketResult.getFare()));
        trainTicket.setTaxRate(WordUtil.getFirstWord(trainTicketResult.getTaxRate()));
        trainTicket.setTax(WordUtil.getFirstWord(trainTicketResult.getTax()));
        trainTicket.setElecTicketNum(WordUtil.getFirstWord(trainTicketResult.getElecTicketNum()));
        trainTicket.setPurchaserName(WordUtil.getFirstWord(trainTicketResult.getPurchaserName()));
        trainTicket.setPurchaserRegisterNum(WordUtil.getFirstWord(trainTicketResult.getPurchaserRegisterNum()));
        return trainTicket;
    }

    public static MultipleInvoiceVo.VatInvoice convertVatInvoice(MultipleInvoiceResponse.VatInvoiceResult vatInvoiceResult) {
        List<Word> commodityTax;
        List<Word> commodityTaxRate;
        List<Word> commodityAmount;
        List<Word> commodityPrice;
        List<Word> commodityNum;
        List<Word> commodityUnit;
        List<Word> commodityType;
        Assert.notNull((Object)vatInvoiceResult, (CharSequence)"vatInvoiceResult must not be null", (Object[])new Object[0]);
        MultipleInvoiceVo.VatInvoice vatInvoice = new MultipleInvoiceVo.VatInvoice();
        vatInvoice.setServiceType(WordUtil.getFirstWord(vatInvoiceResult.getServiceType()));
        vatInvoice.setInvoiceTypeOrg(WordUtil.getFirstWord(vatInvoiceResult.getInvoiceTypeOrg()));
        vatInvoice.setInvoiceType(WordUtil.getFirstWord(vatInvoiceResult.getInvoiceType()));
        vatInvoice.setInvoiceTag(WordUtil.getFirstWord(vatInvoiceResult.getInvoiceTag()));
        vatInvoice.setInvoiceCode(WordUtil.getFirstWord(vatInvoiceResult.getInvoiceCode()));
        vatInvoice.setInvoiceNum(WordUtil.getFirstWord(vatInvoiceResult.getInvoiceNum()));
        vatInvoice.setInvoiceCodeConfirm(WordUtil.getFirstWord(vatInvoiceResult.getInvoiceCodeConfirm()));
        vatInvoice.setInvoiceNumConfirm(WordUtil.getFirstWord(vatInvoiceResult.getInvoiceNumConfirm()));
        vatInvoice.setCheckCode(WordUtil.getFirstWord(vatInvoiceResult.getCheckCode()));
        vatInvoice.setInvoiceNumDigit(WordUtil.getFirstWord(vatInvoiceResult.getInvoiceNumDigit()));
        vatInvoice.setInvoiceDate(WordUtil.getFirstWord(vatInvoiceResult.getInvoiceDate()));
        vatInvoice.setPurchaserName(WordUtil.getFirstWord(vatInvoiceResult.getPurchaserName()));
        vatInvoice.setPurchaserRegisterNum(WordUtil.getFirstWord(vatInvoiceResult.getPurchaserRegisterNum()));
        vatInvoice.setPurchaserAddress(WordUtil.getFirstWord(vatInvoiceResult.getPurchaserAddress()));
        vatInvoice.setPurchaserBank(WordUtil.getFirstWord(vatInvoiceResult.getPurchaserBank()));
        vatInvoice.setPassword(WordUtil.getFirstWord(vatInvoiceResult.getPassword()));
        vatInvoice.setProvince(WordUtil.getFirstWord(vatInvoiceResult.getProvince()));
        vatInvoice.setCity(WordUtil.getFirstWord(vatInvoiceResult.getCity()));
        vatInvoice.setSheetNum(WordUtil.getFirstWord(vatInvoiceResult.getSheetNum()));
        vatInvoice.setAgent(WordUtil.getFirstWord(vatInvoiceResult.getAgent()));
        vatInvoice.setOnlinePay(WordUtil.getFirstWord(vatInvoiceResult.getOnlinePay()));
        vatInvoice.setSellerName(WordUtil.getFirstWord(vatInvoiceResult.getSellerName()));
        vatInvoice.setSellerRegisterNum(WordUtil.getFirstWord(vatInvoiceResult.getSellerRegisterNum()));
        vatInvoice.setSellerAddress(WordUtil.getFirstWord(vatInvoiceResult.getSellerAddress()));
        vatInvoice.setSellerBank(WordUtil.getFirstWord(vatInvoiceResult.getSellerBank()));
        vatInvoice.setTotalAmount(WordUtil.getFirstWord(vatInvoiceResult.getTotalAmount()));
        vatInvoice.setTotalTax(WordUtil.getFirstWord(vatInvoiceResult.getTotalTax()));
        vatInvoice.setAmountInWords(WordUtil.getFirstWord(vatInvoiceResult.getAmountInWords()));
        vatInvoice.setAmountInFiguers(WordUtil.getFirstWord(vatInvoiceResult.getAmountInFiguers()));
        vatInvoice.setPayee(WordUtil.getFirstWord(vatInvoiceResult.getPayee()));
        vatInvoice.setChecker(WordUtil.getFirstWord(vatInvoiceResult.getChecker()));
        vatInvoice.setNoteDrawer(WordUtil.getFirstWord(vatInvoiceResult.getNoteDrawer()));
        vatInvoice.setRemarks(WordUtil.getFirstWord(vatInvoiceResult.getRemarks()));
        vatInvoice.setTotalPage(WordUtil.getFirstWord(vatInvoiceResult.getTotalPage()));
        vatInvoice.setCurrentPage(WordUtil.getFirstWord(vatInvoiceResult.getCurrentPage()));
        vatInvoice.setSubTotalAmount(WordUtil.getFirstWord(vatInvoiceResult.getSubTotalAmount()));
        vatInvoice.setSubTotalTax(WordUtil.getFirstWord(vatInvoiceResult.getSubTotalTax()));
        ArrayList<MultipleInvoiceVo.VatInvoice.Detail> details = new ArrayList<MultipleInvoiceVo.VatInvoice.Detail>();
        vatInvoice.setDetails(details);
        List<Word> commodityName = vatInvoiceResult.getCommodityName();
        if (CollUtil.isNotEmpty(commodityName)) {
            while (details.size() < commodityName.size()) {
                details.add(new MultipleInvoiceVo.VatInvoice.Detail());
            }
            for (int i = 0; i < commodityName.size(); ++i) {
                Word word = commodityName.get(i);
                if (word == null) continue;
                ((MultipleInvoiceVo.VatInvoice.Detail)details.get(i)).setCommodityName(word.getWord());
            }
        }
        if (CollUtil.isNotEmpty(commodityType = vatInvoiceResult.getCommodityType())) {
            while (details.size() < commodityType.size()) {
                details.add(new MultipleInvoiceVo.VatInvoice.Detail());
            }
            for (int i = 0; i < commodityType.size(); ++i) {
                Word word = commodityType.get(i);
                if (word == null) continue;
                ((MultipleInvoiceVo.VatInvoice.Detail)details.get(i)).setCommodityType(word.getWord());
            }
        }
        if (CollUtil.isNotEmpty(commodityUnit = vatInvoiceResult.getCommodityUnit())) {
            while (details.size() < commodityUnit.size()) {
                details.add(new MultipleInvoiceVo.VatInvoice.Detail());
            }
            for (int i = 0; i < commodityUnit.size(); ++i) {
                Word word = commodityUnit.get(i);
                if (word == null) continue;
                ((MultipleInvoiceVo.VatInvoice.Detail)details.get(i)).setCommodityUnit(word.getWord());
            }
        }
        if (CollUtil.isNotEmpty(commodityNum = vatInvoiceResult.getCommodityNum())) {
            while (details.size() < commodityNum.size()) {
                details.add(new MultipleInvoiceVo.VatInvoice.Detail());
            }
            for (int i = 0; i < commodityNum.size(); ++i) {
                Word word = commodityNum.get(i);
                if (word == null) continue;
                ((MultipleInvoiceVo.VatInvoice.Detail)details.get(i)).setCommodityNum(word.getWord());
            }
        }
        if (CollUtil.isNotEmpty(commodityPrice = vatInvoiceResult.getCommodityPrice())) {
            while (details.size() < commodityPrice.size()) {
                details.add(new MultipleInvoiceVo.VatInvoice.Detail());
            }
            for (int i = 0; i < commodityPrice.size(); ++i) {
                Word word = commodityPrice.get(i);
                if (word == null) continue;
                ((MultipleInvoiceVo.VatInvoice.Detail)details.get(i)).setCommodityPrice(word.getWord());
            }
        }
        if (CollUtil.isNotEmpty(commodityAmount = vatInvoiceResult.getCommodityAmount())) {
            while (details.size() < commodityAmount.size()) {
                details.add(new MultipleInvoiceVo.VatInvoice.Detail());
            }
            for (int i = 0; i < commodityAmount.size(); ++i) {
                Word word = commodityAmount.get(i);
                if (word == null) continue;
                ((MultipleInvoiceVo.VatInvoice.Detail)details.get(i)).setCommodityAmount(word.getWord());
            }
        }
        if (CollUtil.isNotEmpty(commodityTaxRate = vatInvoiceResult.getCommodityTaxRate())) {
            while (details.size() < commodityTaxRate.size()) {
                details.add(new MultipleInvoiceVo.VatInvoice.Detail());
            }
            for (int i = 0; i < commodityTaxRate.size(); ++i) {
                Word word = commodityTaxRate.get(i);
                if (word == null) continue;
                ((MultipleInvoiceVo.VatInvoice.Detail)details.get(i)).setCommodityTaxRate(word.getWord());
            }
        }
        if (CollUtil.isNotEmpty(commodityTax = vatInvoiceResult.getCommodityTax())) {
            while (details.size() < commodityTax.size()) {
                details.add(new MultipleInvoiceVo.VatInvoice.Detail());
            }
            for (int i = 0; i < commodityTax.size(); ++i) {
                Word word = commodityTax.get(i);
                if (word == null) continue;
                ((MultipleInvoiceVo.VatInvoice.Detail)details.get(i)).setCommodityTax(word.getWord());
            }
        }
        return vatInvoice;
    }
}

