/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.spring.boot.bdocr.model;

import cn.hutool.v7.core.codec.binary.Base64;
import cn.hutool.v7.core.io.IoUtil;
import cn.hutool.v7.core.io.file.FileTypeUtil;
import cn.hutool.v7.core.net.url.UrlEncoder;
import cn.hutool.v7.http.HttpUtil;
import cn.hutool.v7.http.client.Response;
import cn.toint.oktool.util.Assert;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class BaseOcrRequest {
    private String image;
    private String url;
    @JsonProperty(value="pdf_file")
    private String pdfFile;
    @JsonProperty(value="pdf_file_num")
    private Integer pdfFileNum;
    @JsonProperty(value="ofd_file")
    private String ofdFile;
    @JsonProperty(value="ofd_file_num")
    private Integer ofdFileNum;

    public BaseOcrRequest() {
    }

    public BaseOcrRequest(String url) {
        this.file(url);
    }

    public BaseOcrRequest(byte[] bytes) {
        this.file(bytes);
    }

    public BaseOcrRequest file(String fileUrl) {
        BaseOcrRequest baseOcrRequest;
        block8: {
            Assert.notBlank((CharSequence)fileUrl, (CharSequence)"fileUrl must not be blank", (Object[])new Object[0]);
            Response response = HttpUtil.createGet((String)fileUrl).setMaxRedirects(3).send();
            try {
                long contentLength = response.contentLength();
                this.checkFileSize(contentLength);
                byte[] fileBytes = response.bodyBytes();
                this.checkFileSize(fileBytes.length);
                baseOcrRequest = this.file(fileBytes);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            response.close();
        }
        return baseOcrRequest;
    }

    public BaseOcrRequest file(byte[] fileBytes) {
        String type;
        try (ByteArrayInputStream byteArrayInputStream = IoUtil.toStream((byte[])fileBytes);){
            type = FileTypeUtil.getType((InputStream)byteArrayInputStream);
            Assert.notBlank((CharSequence)type, (CharSequence)"\u65e0\u6cd5\u8bfb\u53d6\u6587\u4ef6\u683c\u5f0f", (Object[])new Object[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if ("pdf".equalsIgnoreCase(type)) {
            this.setPdfFile(this.urlEncodeAndBase64(fileBytes));
        } else if ("ofd".equalsIgnoreCase(type)) {
            this.setOfdFile(this.urlEncodeAndBase64(fileBytes));
        } else if (List.of("jpg", "jpeg", "png", "bmp").contains(type)) {
            this.setImage(this.urlEncodeAndBase64(fileBytes));
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u683c\u5f0f: " + type);
        }
        return this;
    }

    private void checkFileSize(long fileSize) {
        if (fileSize <= 0L) {
            throw new RuntimeException("\u65e0\u6548\u7684\u6587\u4ef6");
        }
        if (fileSize > 0x400000L) {
            throw new RuntimeException("\u6587\u4ef6\u8fc7\u5927");
        }
    }

    private String urlEncodeAndBase64(byte[] fileBytes) {
        return UrlEncoder.encodeQuery((String)Base64.encode((byte[])fileBytes));
    }

    private static String urlEncodeAndBase64(File file) {
        return UrlEncoder.encodeQuery((String)Base64.encode((File)file));
    }

    public void checkFile() {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.getUrl(), this.getImage(), this.getPdfFile(), this.getOfdFile()})) {
            throw new RuntimeException("image/url/pdf_file/ofd_file, 4\u90091");
        }
    }

    @Generated
    public String getImage() {
        return this.image;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getPdfFile() {
        return this.pdfFile;
    }

    @Generated
    public Integer getPdfFileNum() {
        return this.pdfFileNum;
    }

    @Generated
    public String getOfdFile() {
        return this.ofdFile;
    }

    @Generated
    public Integer getOfdFileNum() {
        return this.ofdFileNum;
    }

    @Generated
    public void setImage(String image) {
        this.image = image;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @JsonProperty(value="pdf_file")
    @Generated
    public void setPdfFile(String pdfFile) {
        this.pdfFile = pdfFile;
    }

    @JsonProperty(value="pdf_file_num")
    @Generated
    public void setPdfFileNum(Integer pdfFileNum) {
        this.pdfFileNum = pdfFileNum;
    }

    @JsonProperty(value="ofd_file")
    @Generated
    public void setOfdFile(String ofdFile) {
        this.ofdFile = ofdFile;
    }

    @JsonProperty(value="ofd_file_num")
    @Generated
    public void setOfdFileNum(Integer ofdFileNum) {
        this.ofdFileNum = ofdFileNum;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseOcrRequest)) {
            return false;
        }
        BaseOcrRequest other = (BaseOcrRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$pdfFileNum = this.getPdfFileNum();
        Integer other$pdfFileNum = other.getPdfFileNum();
        if (this$pdfFileNum == null ? other$pdfFileNum != null : !((Object)this$pdfFileNum).equals(other$pdfFileNum)) {
            return false;
        }
        Integer this$ofdFileNum = this.getOfdFileNum();
        Integer other$ofdFileNum = other.getOfdFileNum();
        if (this$ofdFileNum == null ? other$ofdFileNum != null : !((Object)this$ofdFileNum).equals(other$ofdFileNum)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$pdfFile = this.getPdfFile();
        String other$pdfFile = other.getPdfFile();
        if (this$pdfFile == null ? other$pdfFile != null : !this$pdfFile.equals(other$pdfFile)) {
            return false;
        }
        String this$ofdFile = this.getOfdFile();
        String other$ofdFile = other.getOfdFile();
        return !(this$ofdFile == null ? other$ofdFile != null : !this$ofdFile.equals(other$ofdFile));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseOcrRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $pdfFileNum = this.getPdfFileNum();
        result = result * 59 + ($pdfFileNum == null ? 43 : ((Object)$pdfFileNum).hashCode());
        Integer $ofdFileNum = this.getOfdFileNum();
        result = result * 59 + ($ofdFileNum == null ? 43 : ((Object)$ofdFileNum).hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $pdfFile = this.getPdfFile();
        result = result * 59 + ($pdfFile == null ? 43 : $pdfFile.hashCode());
        String $ofdFile = this.getOfdFile();
        result = result * 59 + ($ofdFile == null ? 43 : $ofdFile.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BaseOcrRequest(image=" + this.getImage() + ", url=" + this.getUrl() + ", pdfFile=" + this.getPdfFile() + ", pdfFileNum=" + this.getPdfFileNum() + ", ofdFile=" + this.getOfdFile() + ", ofdFileNum=" + this.getOfdFileNum() + ")";
    }
}

