/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.spring.boot.bdocr;

import cn.hutool.v7.core.map.MapUtil;
import cn.hutool.v7.core.net.url.UrlBuilder;
import cn.hutool.v7.http.HttpUtil;
import cn.hutool.v7.http.client.Request;
import cn.hutool.v7.http.client.Response;
import cn.hutool.v7.http.client.body.HttpBody;
import cn.hutool.v7.http.client.body.UrlEncodedFormBody;
import cn.hutool.v7.http.meta.Method;
import cn.toint.oktool.spring.boot.bdocr.BdOcrClientConfig;
import cn.toint.oktool.spring.boot.bdocr.model.MultipleInvoiceRequest;
import cn.toint.oktool.spring.boot.bdocr.model.MultipleInvoiceResponse;
import cn.toint.oktool.spring.boot.bdocr.model.TokenResponse;
import cn.toint.oktool.spring.boot.bdocr.model.VatInvoiceRequest;
import cn.toint.oktool.spring.boot.bdocr.model.VatInvoiceResponse;
import cn.toint.oktool.spring.boot.bdocr.model.VatInvoiceVerificationRequest;
import cn.toint.oktool.spring.boot.bdocr.model.VatInvoiceVerificationResponse;
import cn.toint.oktool.spring.boot.cache.Cache;
import cn.toint.oktool.util.Assert;
import cn.toint.oktool.util.JacksonUtil;
import cn.toint.oktool.util.KeyBuilderUtil;
import cn.toint.oktool.util.RetryUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BdOcrClient {
    private BdOcrClientConfig bdOcrClientConfig;
    private Cache cache;
    private final KeyBuilderUtil cacheKeyBuilder = KeyBuilderUtil.of((String)"bdOcrToken");

    public BdOcrClient(BdOcrClientConfig bdOcrClientConfig, Cache cache) {
        Assert.validate((Object)bdOcrClientConfig, (Class[])new Class[0]);
        Assert.notNull((Object)cache, (CharSequence)"cache must not be null", (Object[])new Object[0]);
        this.bdOcrClientConfig = bdOcrClientConfig;
        this.cache = cache;
    }

    public String getToken() {
        String cacheToken = this.cache.get(this.cacheKeyBuilder.build(this.bdOcrClientConfig.getApiKey()));
        if (StringUtils.isNotBlank((CharSequence)cacheToken)) {
            return cacheToken;
        }
        String url = UrlBuilder.ofHttp((String)"https://aip.baidubce.com/oauth/2.0/token").addQuery("grant_type", (Object)"client_credentials").addQuery("client_id", (Object)this.bdOcrClientConfig.getApiKey()).addQuery("client_secret", (Object)this.bdOcrClientConfig.getSecretKey()).build();
        TokenResponse tokenResponse = (TokenResponse)RetryUtil.execute(() -> {
            TokenResponse tokenResponse;
            block8: {
                Response response = HttpUtil.createGet((String)url).send();
                try {
                    String bodyStr = response.bodyStr();
                    Assert.notBlank((CharSequence)bodyStr, (CharSequence)"baidu error, body is null", (Object[])new Object[0]);
                    TokenResponse tokenResponseOrigin = (TokenResponse)JacksonUtil.readValue((String)bodyStr, TokenResponse.class);
                    Assert.notBlank((CharSequence)tokenResponseOrigin.getAccessToken(), (CharSequence)"baidu error, access token is null", (Object[])new Object[0]);
                    Assert.notNull((Object)tokenResponseOrigin.getExpires_in(), (CharSequence)"baidu error, expires_in is null", (Object[])new Object[0]);
                    tokenResponse = tokenResponseOrigin;
                    if (response == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
                response.close();
            }
            return tokenResponse;
        });
        this.cache.put(this.cacheKeyBuilder.build(this.bdOcrClientConfig.getApiKey()), tokenResponse.getAccessToken(), Duration.ofSeconds(tokenResponse.getExpires_in()));
        return tokenResponse.getAccessToken();
    }

    private String request(Method method, String url, HttpBody body) {
        Assert.notNull((Object)method, (CharSequence)"method must not be null", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)url, (CharSequence)"url must not be blank", (Object[])new Object[0]);
        Assert.notNull((Object)body, (CharSequence)"body must not be null", (Object[])new Object[0]);
        Request request = Request.of((String)url).method(method).body(body);
        return this.request(request);
    }

    private String request(Request request) {
        Assert.notNull((Object)request, (CharSequence)"request must not be null", (Object[])new Object[0]);
        String token = this.getToken();
        request.url().addQuery("access_token", (Object)token);
        return (String)RetryUtil.execute(() -> {
            try (Response response = request.send();){
                String bodyStr = response.bodyStr();
                Assert.notBlank((CharSequence)bodyStr, (CharSequence)"baidu error, body is null", (Object[])new Object[0]);
                String string = bodyStr;
                return string;
            }
        });
    }

    public MultipleInvoiceResponse multipleInvoice(MultipleInvoiceRequest request) {
        Assert.notNull((Object)request, (CharSequence)"request must not be null", (Object[])new Object[0]);
        request.checkFile();
        Map bodyMap = (Map)JacksonUtil.convertValue((Object)request, (TypeReference)new TypeReference<Map<String, Object>>(this){});
        MapUtil.removeNullValue((Map)bodyMap);
        UrlEncodedFormBody urlEncodedFormBody = UrlEncodedFormBody.of((Map)bodyMap, (Charset)StandardCharsets.UTF_8);
        String url = "https://aip.baidubce.com/rest/2.0/ocr/v1/multiple_invoice";
        String responseStr = this.request(Method.POST, url, (HttpBody)urlEncodedFormBody);
        return (MultipleInvoiceResponse)((MultipleInvoiceResponse)JacksonUtil.readValue((String)responseStr, MultipleInvoiceResponse.class)).checkStatus();
    }

    public VatInvoiceResponse vatInvoice(VatInvoiceRequest request) {
        Assert.notNull((Object)request, (CharSequence)"request must not be null", (Object[])new Object[0]);
        request.checkFile();
        Map bodyMap = (Map)JacksonUtil.convertValue((Object)request, (TypeReference)new TypeReference<Map<String, Object>>(this){});
        MapUtil.removeNullValue((Map)bodyMap);
        UrlEncodedFormBody urlEncodedFormBody = UrlEncodedFormBody.of((Map)bodyMap, (Charset)StandardCharsets.UTF_8);
        String url = "https://aip.baidubce.com/rest/2.0/ocr/v1/vat_invoice";
        String responseStr = this.request(Method.POST, url, (HttpBody)urlEncodedFormBody);
        return (VatInvoiceResponse)((VatInvoiceResponse)JacksonUtil.readValue((String)responseStr, VatInvoiceResponse.class)).checkStatus();
    }

    public VatInvoiceVerificationResponse vatInvoiceVerification(VatInvoiceVerificationRequest request) {
        Assert.notNull((Object)request, (CharSequence)"request must not be null", (Object[])new Object[0]);
        Map bodyMap = (Map)JacksonUtil.convertValue((Object)request, (TypeReference)new TypeReference<Map<String, Object>>(this){});
        MapUtil.removeNullValue((Map)bodyMap);
        UrlEncodedFormBody urlEncodedFormBody = UrlEncodedFormBody.of((Map)bodyMap, (Charset)StandardCharsets.UTF_8);
        String url = "https://aip.baidubce.com/rest/2.0/ocr/v1/vat_invoice_verification";
        String responseStr = this.request(Method.POST, url, (HttpBody)urlEncodedFormBody);
        return (VatInvoiceVerificationResponse)((VatInvoiceVerificationResponse)JacksonUtil.readValue((String)responseStr, VatInvoiceVerificationResponse.class)).checkStatus();
    }
}

