/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oktool.spring.boot.util;

import cn.toint.oktool.util.Assert;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisLockUtil {
    private static StringRedisTemplate stringRedisTemplate;

    public static void setStringRedisTemplate(StringRedisTemplate stringRedisTemplate) {
        RedisLockUtil.stringRedisTemplate = stringRedisTemplate;
    }

    public static boolean lock(String key, long timeout) {
        return RedisLockUtil.lock(key, timeout, TimeUnit.MILLISECONDS);
    }

    public static boolean lock(String key, long timeout, TimeUnit unit) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key must not be blank", (Object[])new Object[0]);
        Assert.notNull((Object)((Object)unit), (CharSequence)"unit must not be null", (Object[])new Object[0]);
        Assert.isTrue((timeout > 0L ? 1 : 0) != 0, (CharSequence)"timeout \u5fc5\u987b\u5927\u4e8e 0", (Object[])new Object[0]);
        Boolean setIfAbsent = stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)"", timeout, unit);
        return Boolean.TRUE.equals(setIfAbsent);
    }

    public static void unlock(String key) {
        Assert.notBlank((CharSequence)key, (CharSequence)"key must not be blank", (Object[])new Object[0]);
        stringRedisTemplate.delete((Object)key);
    }
}

