/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oksms.email;

import cn.hutool.v7.core.collection.CollUtil;
import cn.hutool.v7.extra.mail.Mail;
import cn.hutool.v7.extra.mail.MailAccount;
import cn.toint.oksms.email.model.MailClientConfig;
import cn.toint.oksms.email.model.MailSendRequest;
import cn.toint.oksms.email.model.MailSendResponse;
import cn.toint.oktool.util.Assert;
import java.io.File;
import java.util.List;

public class MailClient {
    private final MailClientConfig mailClientConfig;

    public MailClient(MailClientConfig mailClientConfig) {
        this.mailClientConfig = mailClientConfig;
    }

    public MailSendResponse send(MailSendRequest request) {
        List<File> files;
        List<String> replys;
        List<String> bccs;
        Assert.notNull((Object)request, (CharSequence)"\u90ae\u4ef6\u53d1\u9001\u8bf7\u6c42\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.validate((Object)request, (CharSequence)"\u90ae\u4ef6\u53d1\u9001\u8bf7\u6c42\u6821\u9a8c\u5931\u8d25: {}", (Object[])new Object[0]);
        Mail mail = Mail.of((MailAccount)this.mailClientConfig).setUseGlobalSession(request.isUseGlobalSession());
        List<String> ccs = request.getCcs();
        if (CollUtil.isNotEmpty(ccs)) {
            mail.setCcs(ccs.toArray(new String[0]));
        }
        if (CollUtil.isNotEmpty(bccs = request.getBccs())) {
            mail.setBccs(bccs.toArray(new String[0]));
        }
        if (CollUtil.isNotEmpty(replys = request.getReplys())) {
            mail.setReply(replys.toArray(new String[0]));
        }
        if (CollUtil.isNotEmpty(files = request.getFiles())) {
            mail.setFiles(files.toArray(new File[0]));
        }
        mail.setTos(request.getTos().toArray(new String[0]));
        mail.setTitle(request.getSubject());
        mail.setContent(request.getContent());
        mail.setHtml(request.isHtml());
        String msgId = mail.send();
        MailSendResponse mailSendResponse = new MailSendResponse();
        mailSendResponse.setMsgId(msgId);
        return mailSendResponse;
    }
}

