/*
 * Decompiled with CFR 0.152.
 */
package cn.toint.oksms.aliyun;

import cn.toint.oksms.aliyun.model.AliyunSmsClientConfig;
import cn.toint.oksms.aliyun.model.AliyunSmsSendRequest;
import cn.toint.oksms.aliyun.model.AliyunSmsSendResponse;
import cn.toint.oktool.util.Assert;
import cn.toint.oktool.util.JacksonUtil;
import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendSmsResponse;
import com.aliyun.dysmsapi20170525.models.SendSmsResponseBody;
import com.aliyun.teaopenapi.models.Config;
import java.util.Map;
import org.dromara.hutool.core.map.MapUtil;

public class AliyunSmsClient {
    private final Client client;

    public AliyunSmsClient(AliyunSmsClientConfig aliyunSmsClientConfig) {
        Assert.notNull((Object)aliyunSmsClientConfig, (CharSequence)"\u963f\u91cc\u4e91\u77ed\u4fe1\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Config config = new Config();
        config.setAccessKeyId(aliyunSmsClientConfig.getAccessKeyId());
        config.setAccessKeySecret(aliyunSmsClientConfig.getAccessKeySecret());
        config.setEndpoint(aliyunSmsClientConfig.getEndpoint());
        config.setRegionId(aliyunSmsClientConfig.getRegionId());
        config.setReadTimeout(Integer.valueOf(aliyunSmsClientConfig.getReadTimeout()));
        config.setConnectTimeout(Integer.valueOf(aliyunSmsClientConfig.getConnectTimeout()));
        try {
            this.client = new Client(config);
        }
        catch (Exception e) {
            throw new RuntimeException("\u963f\u91cc\u4e91\u77ed\u4fe1\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public AliyunSmsSendResponse send(AliyunSmsSendRequest aliyunSmsSendRequest) {
        String phoneNumbers = String.join((CharSequence)",", aliyunSmsSendRequest.getPhoneNumbers());
        try {
            SendSmsRequest sendSmsRequest = new SendSmsRequest();
            sendSmsRequest.setPhoneNumbers(phoneNumbers);
            sendSmsRequest.setSignName(aliyunSmsSendRequest.getSignName());
            sendSmsRequest.setTemplateCode(aliyunSmsSendRequest.getTemplateCode());
            Map<String, Object> templateParam = aliyunSmsSendRequest.getTemplateParam();
            if (MapUtil.isNotEmpty(templateParam)) {
                sendSmsRequest.setTemplateParam(JacksonUtil.writeValueAsString(templateParam));
            }
            SendSmsResponse sendSmsResponse = this.client.sendSms(sendSmsRequest);
            SendSmsResponseBody responseBody = sendSmsResponse.getBody();
            AliyunSmsSendResponse aliyunSmsSendResponse = new AliyunSmsSendResponse();
            aliyunSmsSendResponse.setBizId(responseBody.getBizId());
            aliyunSmsSendResponse.setCode(responseBody.getCode());
            aliyunSmsSendResponse.setMessage(responseBody.getMessage());
            aliyunSmsSendResponse.setRequestId(responseBody.getRequestId());
            return aliyunSmsSendResponse;
        }
        catch (Exception e) {
            throw new RuntimeException("\u963f\u91cc\u4e91\u77ed\u4fe1\u53d1\u9001\u5931\u8d25: " + e.getMessage(), e);
        }
    }
}

