package zkclient.serializer;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import zkclient.exception.ZkSerializerException;

/**
 * @Date 2018-09-18 desc:@param faster JSON 序列化
 */

public class ProtobufSerializer<T extends MessageLite> implements ZookeeperSerializer {

	private MessageLite prototype;


	public ProtobufSerializer(MessageLite messageLite) {
		this.prototype = messageLite.getDefaultInstanceForType();
	}

	@Override
	public byte[] serialize(Object obj) {
		if (!(obj instanceof MessageLite)) {
			throw new ZkSerializerException("Target Object not implements MessageLite");
		}
		return ((MessageLite) obj).toByteArray();
	}

	@Override
	public MessageLite deserialize(byte[] bytes) {

		MessageLite obj = null;
		try {
			obj = prototype.getParserForType().parseFrom(bytes);
		} catch (InvalidProtocolBufferException e) {
			throw new ZkSerializerException("protobuf bytes parse to protobuf object error!", e);
		}
		return obj;
	}

	@Override
	public Class<?> getDeserializeTargetClass() {
		return MessageLite.class;
	}

}
