package zkclient.serializer;

import org.apache.commons.lang3.SerializationUtils;
import zkclient.exception.ZkSerializerException;

import java.io.Serializable;

/**
 * 
 * @author mxsm
 * @Date 2018-09-18
 * desc:@param <T>  Java 序列化
 */

public class JavaSerializer<T extends Serializable> implements ZookeeperSerializer{

	@Override
	public byte[] serialize(Object obj) {
		
		if(!(obj instanceof Serializable)) {
			throw new ZkSerializerException("Target Object to serialize not implements Serializable interface");
		}
		return SerializationUtils.serialize((Serializable)obj);
	}

	@Override
	public T deserialize(byte[] bytes) {
		return SerializationUtils.deserialize(bytes);
	}

	@Override
	public Class<?> getDeserializeTargetClass() {
		return Serializable.class;
	}
}
