JSON in Java [package org.json]
===============================

该软件包中的文件使用Java实现JSON编码器/解码器。它还具有在JSON和XML，HTTP标头，Cookie和CDL之间转换的功能。

这是参考实现。Java中有大量的JSON包。也许有一天，Java社区将标准化一个。在此之前，请仔细选择。

许可证包括以下限制：“软件应被用于善良，而不是邪恶。” 如果您的良心无法忍受，那么请选择其他套餐。

该软件包在Java 1.6-1.8上编译。

JSONObject.java：JSONObject可以解析来自String或的文本JSONTokener 以生成类似地图的对象。该对象提供用于操作其内容以及产生JSON兼容对象序列化的方法。

JSONArray.java：JSONArray可以解析String或a中的文本JSONTokener 以生成类似矢量的对象。该对象提供用于操纵其内容以及产生JSON兼容数组序列化的方法。

JSONTokener.java：将JSONTokener文本分为一系列单独的令牌。它可以从一个被构造String，Reader或InputStream。

JSONException.java：JSONException是此程序包引发的标准异常类型。

JSONPointer.java：实施 JSON指针（RFC 6901） 。支持以字符串表示形式和URI片段表示形式的JSON指针。

JSONPropertyIgnore.java：可以在Java Bean getter方法上使用的Annotation类。在通常会序列化为a的bean方法上使用时JSONObject，它将覆盖getter-to-key-name逻辑，并强制将属性从结果中排除JSONObject。

JSONPropertyName.java：可以在Java Bean getter方法上使用的Annotation类。当在通常会序列化为的bean方法上使用时JSONObject，它将覆盖getter-to-key-name逻辑，并使用注释的值。Bean处理器将遍历类层次结构。这意味着您可以在基类或接口上使用注释，并且即使在子类中重写了getter，注释的值也将被使用。

JSONString.java：JSONString接口需要一个toJSONString方法，允许对象提供自己的序列化。

JSONStringer.java：JSONStringer提供了用于构建JSON字符串的便利工具。

JSONWriter.java：JSONWriter提供了通过编写器构建JSON文本的便利工具。

CDL.java：CDL提供在JSON和逗号分隔列表之间转换的支持。

Cookie.java：Cookie支持在JSON和cookie之间进行转换。

CookieList.java：CookieList提供在JSON和cookie列表之间转换的支持。

HTTP.java：HTTP提供在JSON和HTTP标头之间转换的支持。

HTTPTokener.java：HTTPTokener扩展JSONTokener用于解析HTTP标头。

XML.java：XML提供在JSON和XML之间转换的支持。

JSONML.java：JSONML提供在JSONML和XML之间转换的支持。

XMLTokener.java：用于解析XML文本的XMLTokener扩展JSONTokener。
此软件包中的数字类型符合 ECMA-404：JSON数据交换格式和 RFC 8259：JavaScript对象表示法（JSON）数据交换格式。该软件包完全支持Integer，Long以及DoubleJava类型。用于部分支撑BigInteger并BigDecimal在值JSONObject和JSONArray对象以的形式提供get()，opt()以及put()API方法。

尽管目前支持1.6兼容性，但这不是项目目标，在将来的某些发行版中可能会删除它。

根据RFC8259第10页第9节的规定，解析器使用有效JSON的内容比生成器更为宽松。例如，读取JSON文本字符串时允许使用制表符（U + 0009），但在Generator生成的输出中，制表符会在字符串中正确转换为\ t。在读取无效的JSON文本不会导致生成错误的情况下，可能会发生其他情况。格式错误的JSON文本，例如字符串末尾的“（引号）丢失或无效的数字格式（1.2e6.3）”将导致错误，因为无法可靠地读取此类文档。

该库中的JSON解析器接受的一些值得注意的例外是：

未加引号的键 { key: "value" }
未报价的值 { "key": value }
字符串值中未转义的文字，例如“ tab” { "key": "value with an unescaped tab" }
数字超出范围Double或被Long解析为字符串