<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE mapper PUBLIC "-//mybatis.org//DTD Mapper 3.0//EN" "http://mybatis.org/dtd/mybatis-3-mapper.dtd" >
<mapper namespace="${tableProNameUrl}">
    <resultMap id="${tableProName?cap_first}BaseMap" type="${tableProNameUrl}">
        <#list fieldList as pro>
            <#if pro.isPk == 1>
                <id column="${pro.name}" property="${pro.proName}" />
            <#else>
                <result column="${pro.name}" property="${pro.proName}" />
            </#if>
        </#list>
    </resultMap>

    <#--单表字段-->
    <sql id="columns">
        <#list fieldList as pro>
            ${pro.name}<#if pro_has_next>,</#if>
        </#list>
    </sql>

    <!--动态条件-->
    <sql id="dynamicWhere">
        <where>
        <#list fieldList as pro>
            <#if pro.isPk==0>
                <#if (pro.type=="String")>
            <if test="@ognl.Dao@isNotEmpty(${pro.proName})"> AND ${pro.name}  LIKE  concat('%', <#noparse>#{</#noparse>${pro.proName}}, '%') </if>
                    <#else>
                    <#if (pro.type=="Date")>
            <if test="@ognl.Dao@isNotEmpty(${pro.proName})"> AND ${pro.name} = <#noparse>#{</#noparse>${pro.proName}} </if>
            <if test="@ognl.Dao@isNotEmpty(begin${pro.proName?cap_first})"> AND ${pro.name} <![CDATA[ >= <#noparse>#{</#noparse>begin${pro.proName?cap_first}} ]]> </if>
            <if test="@ognl.Dao@isNotEmpty(end${pro.proName?cap_first})"> AND ${pro.name} <![CDATA[ <= <#noparse>#{</#noparse>end${pro.proName?cap_first}} ]]> </if>
                    <#else>
            <if test="@ognl.Dao@isNotEmpty(${pro.proName})"> AND ${pro.name} = <#noparse>#{</#noparse>${pro.proName}} </if>
                    </#if>
                </#if>
            </#if>
        </#list>
        </where>
    </sql>

    <!-- 新增 -->
    <insert id="add" useGeneratedKeys="true" keyProperty="${fieldPk.proName}" parameterType="${tableProNameUrl}">
        INSERT INTO ${tableName} (
            <trim suffixOverrides=",">
                <#list fieldList as pro>
                <if test="@ognl.Dao@isNotEmpty(${pro.proName})"> ${pro.name}<#if pro_has_next>,</#if> </if>
                <#--${r'<if test="@ognl.Dao@isNotEmpty('}${pro.proName}${r')">'} ${pro.name}<#if pro_has_next>,</#if> ${r'</if>'}-->
                </#list>
            </trim>
        ) VALUES (
            <trim suffixOverrides=",">
                <#list fieldList as pro>
                <if test="@ognl.Dao@isNotEmpty(${pro.proName})">   <#noparse>#{</#noparse>${pro.proName}}<#if pro_has_next>,</#if></if>
                <#--${r'<if test="@ognl.Dao@isNotEmpty('}${pro.proName}${r')">'} ${r'#'}{${pro.proName}}<#if pro_has_next>,</#if> ${r'</if>'}-->
                </#list>
            </trim>
        )
    </insert>

    <!-- 批量新增 -->
    <insert id="batchSave" parameterType="java.util.List" >

        INSERT INTO ${tableName} (
                <#list fieldList as pro>
                     ${pro.name}<#if pro_has_next>,</#if>
                </#list>
        ) VALUES
        <foreach collection ="list" index="index" item="item" separator =",">
            (
                <#list fieldList as pro>
                    <#noparse>#{item.</#noparse>${pro.proName}}<#if pro_has_next>,</#if>
                </#list>
            )
        </foreach >
    </insert>



    <!-- 修改 -->
    <update id="update"  parameterType="${tableProNameUrl}">
        UPDATE ${tableName}
            <trim prefix="set" suffixOverrides=",">
                <#list fieldList as pro>
                    <#if pro.isIdentity==0>
                <if test="@ognl.Dao@isNotEmpty(${pro.proName})"> ${pro.name} = <#noparse>#{</#noparse>${pro.proName}}<#if pro_has_next>,</#if> </if>
                <#--${r'<if test="@ognl.Dao@isNotEmpty('}${pro.proName}${r')">'} ${pro.name}=${r'#'}{${pro.proName}}<#if pro_has_next>,</#if> ${r'</if>'}-->
                    </#if>
                </#list>
            </trim>
        WHERE
            ${fieldPk.name}=${r'#'}{${fieldPk.proName}}
    </update>

    <!-- 根据ID主键删除 -->
    <delete id="delById" parameterType="java.lang.${fieldPk.type}" >
        DELETE FROM ${tableName} WHERE ${fieldPk.name} = <#noparse>#{</#noparse>${fieldPk.proName}}
    </delete>

    <!-- 根据ID查询单条 -->
    <select id="getById" parameterType="java.lang.${fieldPk.type}" resultMap="${tableProName?cap_first}BaseMap">
        SELECT <include refid="columns"/>
        FROM ${tableName}
        WHERE
            ${fieldPk.name} = <#noparse>#{</#noparse>${fieldPk.proName}}
    </select>

    <!-- 获取所有的记录,不分页 -->
    <select id="getAll" resultMap="${tableProName?cap_first}BaseMap">
        SELECT <include refid="columns"/>
        FROM ${tableName}
        <include refid="dynamicWhere" />
        <if test="@ognl.Dao@isNotEmpty(orderField)">
            order by <#noparse>${orderField}</#noparse> <#noparse>${orderSeq}</#noparse>
        </if>
        <if test="@ognl.Dao@isEmpty(orderField)">
            order by ${fieldPk.name}  desc
        </if>
    </select>





</mapper>