package cn.dolphin.wechat.wxopen.model.user;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 小程序授权code信息
 */
@Data
public class Jscode2session implements Serializable {

    private static final long serialVersionUID = -1765143267511780352L;

    /**
     * 用户唯一标识
     */
    @JsonProperty("openid")
    private String openId;

    /**
     * 会话密钥
     */
    @JsonProperty("session_keyl")
    private String sessionKeyl;

    /**
     * 用户在开放平台的唯一标识符，在满足 UnionID 下发条件的情况下会返回
     */
    @JsonProperty("unionid")
    private String unionId;

    /**
     * 错误码
     */
    private Integer errcode;

    /**
     * 错误信息
     */
    private String errmsg;

}
