package cn.dolphin.wechat.wxopen.model.message;

import cn.dolphin.wechat.core.util.JsonMapper;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Map;

/**
 * 微信小程序消息模板
 */
@Data
@Accessors(chain = true)
public class WechatTemplate {

    /**
     * 接收者（用户）的 openid
     */
    private String touser;
    /**
     * 所需下发的模板消息的id
     */
    @JsonProperty("template_id")
    private String templateId;
    /**
     * 点击模板卡片后的跳转页面，仅限本小程序内的页面。支持带参数,（示例index?foo=bar）。该字段不填则模板无跳转（非必填）
     *
     */
    private String page; // 跳转小程序页面
    /**
     * 表单提交场景下，为 submit 事件带上的 formId；支付场景下，为本次支付的 prepay_id
     */
    @JsonProperty("form_id")
    private String formId; //表单提交场景下为formid，支付场景下为prepay_id

    /**
     * 模板内容，不填则下发空模板。具体格式请参考示例（非必填）
     */
    private Map<String, WechatTemplateItem> data;
    /**
     * 模板需要放大的关键词，不填则默认无放大（非必填）
     */
    @JsonProperty("emphasis_keyword")
    private String emphasisKeyword; // 需要放大的关键字，如：keyword1.DATA

    /**
     * 转换json
     * @return
     */
    public String toJson() {
        return JsonMapper.defaultMapper().toJson(this);
    }
}
