package cn.dolphin.wechat.mp.model.user;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 用户信息(未关注，但已手动授权)
 */
@Data
public class UserInfo implements Serializable {

    private static final long serialVersionUID = 2478767075011050905L;
    @JsonProperty("openid")
    private String openId;

    @JsonProperty("nickname")
    private String nickName;

    /**
     * 0未知，1男，2女
     */
    private Integer sex;

    private String city;

    private String province;

    private String country;

    @JsonProperty("headimgurl")
    private String headImgUrl;

    @JsonProperty("unionid")
    private String unionId;

    /**
     * 用户特权信息，json数组，如微信沃卡用户为（chinaunicom）
     */
    private String[] privilege;


}
