package cn.dolphin.wechat.mp.model.user;

import cn.dolphin.core.map.MapUtil;
import cn.dolphin.wechat.core.serializer.DateDeserializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户信息
 */
@Data
public class User implements Serializable {

    private static final long serialVersionUID = 3388624286847143502L;
    /**
     * 0未关注，1已关注
     */
    private Integer subscribe;

    /**
     * 用户的唯一标识
     */
    @JsonProperty("openid")
    private String openId;

    /**
     * 用户昵称
     */
    @JsonProperty("nickname")
    private String nickName;

    /**
     * 0未知，1男，2女
     */
    private Integer sex;

    /**
     * 普通用户个人资料填写的城市
     */
    private String city;

    /**
     * 用户个人资料填写的省份
     */
    private String province;

    /**
     * 国家，如中国为CN
     */
    private String country;

    /**
     * 用户头像，最后一个数值代表正方形头像大小（有0、46、64、96、132数值可选，0代表640*640正方形头像），用户没有头像时该项为空。若用户更换头像，原有头像URL将失效。
     */
    @JsonProperty("headimgurl")
    private String headImgUrl;

    @JsonProperty("subscribe_time")
    @JsonDeserialize(using = DateDeserializer.class)
    private Date subscribeTime;

    @JsonProperty("unionid")
    private String unionId;

    private String remark;

    @JsonProperty("groupid")
    private Integer groupId;


    public static void main(String[] args) {
        //System.out.println(Dtos.newDto("key1", new User(), "key2", new User()));
        System.out.println(MapUtil.newHashMap("key1", new User(), "key2", new User()));
    }


}
