package cn.dolphin.wechat.mp.model.message;

import cn.dolphin.wechat.core.util.JsonMapper;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.*;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * 模板消息.
 */
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class WxMpTemplateMessage implements Serializable {
    private static final long serialVersionUID = 5063374783759519418L;

    /**
     * 接收者openid.
     */
    @JsonProperty("touser")
    private String toUser;

    /**
     * 模板ID.
     */
    @JsonProperty("template_id")
    private String templateId;

    /**
     * 模板跳转链接.
     * <pre>
     * url和miniprogram都是非必填字段，若都不传则模板无跳转；若都传，会优先跳转至小程序。
     * 开发者可根据实际需要选择其中一种跳转方式即可。当用户的微信客户端版本不支持跳小程序时，将会跳转至url。
     * </pre>
     */
    private String url;

    /**
     * 跳小程序所需数据，不需跳小程序可不用传该数据.
     */
    @JsonProperty("miniprogram")
    private MiniProgram miniProgram;

    /**
     * 模板数据.
     */
    @Builder.Default
    private Map<String,Object> data = new HashMap<String, Object>();

    public WxMpTemplateMessage addData(Map<String,Object> data) {
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
        this.data.putAll(data);
        return this;
    }

//    /**
//     * 模板数据.
//     */
//    @Builder.Default
//    private List<WxMpTemplateData> data = new ArrayList<WxMpTemplateData>();
//
//    public WxMpTemplateMessage addData(WxMpTemplateData datum) {
//        if (this.data == null) {
//            this.data = new ArrayList<>();
//        }
//        this.data.add(datum);
//        return this;
//    }

    public String toJson() {
        return JsonMapper.nonEmptyMapper().toJson(this);
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class MiniProgram implements Serializable {
        private static final long serialVersionUID = -7945254706501974849L;

        private String appid;
        @JsonProperty("pagepath")
        private String pagePath;

        /**
         * 是否使用path，否则使用pagepath.
         * 加入此字段是基于微信官方接口变化多端的考虑
         */
//        private boolean usePath = true;
    }

}