package cn.dolphin.wechat.mp.enums;

/**
 *  网页认证的状态码
 */
public enum Oauth2Enum {

    // 系统公共状态码
    API_000001("000001","微信公众号授权认证错误，请管理员检查"),
    OAUTH2_10003("10003","redirect_uri域名与后台配置不一致"),
    OAUTH2_10004("10004","此公众号被封禁"),
    OAUTH2_10005("10005","此公众号并没有这些scope的权限"),
    OAUTH2_10006("10006","必须关注此测试号"),
    OAUTH2_10009("10009","操作太频繁了，请稍后重试"),
    OAUTH2_10010("10010","scope不能为空"),
    OAUTH2_10011("10011","redirect_uri不能为空"),
    OAUTH2_10012("10012","appid不能为空"),
    OAUTH2_10013("10013","state不能为空"),
    OAUTH2_10015("10015","公众号未授权第三方平台，请检查授权状态"),
    OAUTH2_10016("10016","不支持微信开放平台的Appid，请使用公众号Appid");


    private String code;
    private String msg;


    /**
     * Msg string.
     *
     * @return the string
     */
    public String msg() {
        return msg;
    }

    /**
     * Code int.
     *
     * @return the int
     */
    public String code() {
        return code;
    }

    Oauth2Enum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    /**
     * Gets enum.
     *
     * @param code the code
     *
     * @return the enum
     */
    public static Oauth2Enum getEnum(String code) {
        for (Oauth2Enum ele : Oauth2Enum.values()) {
            if (ele.code().equals(code)) {
                return ele;
            }
        }
        return API_000001;

    }
}
