package cn.dolphin.wechat.mp.consts;

import lombok.extern.slf4j.Slf4j;

/**
 * 微信公众号授权变量
 */
@Slf4j
public final class MpOAuth2Constant {

    /**
     * 生成OAuth重定向URI（用户同意授权，获取code）
     */
    public static final String OAUTH2_AUTHORIZE = "https://open.weixin.qq.com/connect/oauth2/authorize";
    /**
     * 通过code换取网页授权access_token
     */
    public static final String OAUTH2_ACCESS_TOKEN = "https://api.weixin.qq.com/sns/oauth2/access_token";
    /**
     * 刷新access_token（如果需要）
     */
    public static final String OAUTH2_REFRESH_TOKEN = "https://api.weixin.qq.com/sns/oauth2/refresh_token";
    /**
     * 拉取用户信息(需scope为 snsapi_userinfo)
     */
    public static final String USERINFO = "https://api.weixin.qq.com/sns/userinfo";
    /**
     * 检验授权凭证（access_token）是否有效
     */
    public static final String AUTH = "https://api.weixin.qq.com/sns/auth";










}
