package cn.dolphin.wechat.core.util;

import cn.dolphin.core.exception.ApiException;
import cn.dolphin.core.json.FastJsonUtil;
import cn.dolphin.wechat.core.enums.WechatEnum;
import com.alibaba.fastjson.JSONObject;
import org.apache.http.Consts;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

/**
 * 微信工具类
 */
@SuppressWarnings("all")
public final class Wechatutils {

    /**
     * 使用UTF-8进行URL编码
     *
     * @param str
     * @return
     */
    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, Consts.UTF_8.name());
        } catch (UnsupportedEncodingException e) {
            throw new ApiException(e.getMessage(),e);
        }
    }


    /**
     * 检查响应结果是否正确
     *
     * @param response
     */
    public static void check(String response){
        JSONObject exception = FastJsonUtil.parseObject(response);
        String errcode = exception.getString("errcode");
        String errmsg = exception.getString("errmsg");
        if (errmsg != null && !"ok".equals(errmsg)) {
            throw new ApiException(WechatEnum.getEnum(errcode).code(), WechatEnum.getEnum(errcode).msg());
        }
    }
}
